<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemItemsBeta StructType
 * @subpackage Structs
 */
class RedeemItemsBeta extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The externalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalReferenceId;
    /**
     * The subscriberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberId;
    /**
     * The subscriberIdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberIdType;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $userId;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The purchaseOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPurchaseOrderItem
     */
    public $purchaseOrder;
    /**
     * The deliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryAddress;
    /**
     * The optionalLong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $optionalLong;
    /**
     * The optionalString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $optionalString;
    /**
     * Constructor method for RedeemItemsBeta
     * @uses RedeemItemsBeta::setSource()
     * @uses RedeemItemsBeta::setChannel()
     * @uses RedeemItemsBeta::setExternalReferenceId()
     * @uses RedeemItemsBeta::setSubscriberId()
     * @uses RedeemItemsBeta::setSubscriberIdType()
     * @uses RedeemItemsBeta::setUserId()
     * @uses RedeemItemsBeta::setLanguage()
     * @uses RedeemItemsBeta::setPurchaseOrder()
     * @uses RedeemItemsBeta::setDeliveryAddress()
     * @uses RedeemItemsBeta::setOptionalLong()
     * @uses RedeemItemsBeta::setOptionalString()
     * @param string $source
     * @param string $channel
     * @param int $externalReferenceId
     * @param string $subscriberId
     * @param string $subscriberIdType
     * @param int $userId
     * @param string $language
     * @param \ArrayType\ArrayOfPurchaseOrderItem $purchaseOrder
     * @param string $deliveryAddress
     * @param int $optionalLong
     * @param string $optionalString
     */
    public function __construct($source = null, $channel = null, $externalReferenceId = null, $subscriberId = null, $subscriberIdType = null, $userId = null, $language = null, \ArrayType\ArrayOfPurchaseOrderItem $purchaseOrder = null, $deliveryAddress = null, $optionalLong = null, $optionalString = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setExternalReferenceId($externalReferenceId)
            ->setSubscriberId($subscriberId)
            ->setSubscriberIdType($subscriberIdType)
            ->setUserId($userId)
            ->setLanguage($language)
            ->setPurchaseOrder($purchaseOrder)
            ->setDeliveryAddress($deliveryAddress)
            ->setOptionalLong($optionalLong)
            ->setOptionalString($optionalString);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \StructType\RedeemItemsBeta
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \StructType\RedeemItemsBeta
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get externalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->externalReferenceId;
    }
    /**
     * Set externalReferenceId value
     * @param int $externalReferenceId
     * @return \StructType\RedeemItemsBeta
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->externalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get subscriberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberId()
    {
        return isset($this->subscriberId) ? $this->subscriberId : null;
    }
    /**
     * Set subscriberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberId
     * @return \StructType\RedeemItemsBeta
     */
    public function setSubscriberId($subscriberId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberId) && !is_string($subscriberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberId, true), gettype($subscriberId)), __LINE__);
        }
        if (is_null($subscriberId) || (is_array($subscriberId) && empty($subscriberId))) {
            unset($this->subscriberId);
        } else {
            $this->subscriberId = $subscriberId;
        }
        return $this;
    }
    /**
     * Get subscriberIdType value
     * @return string|null
     */
    public function getSubscriberIdType()
    {
        return $this->subscriberIdType;
    }
    /**
     * Set subscriberIdType value
     * @uses \EnumType\ParamType::valueIsValid()
     * @uses \EnumType\ParamType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberIdType
     * @return \StructType\RedeemItemsBeta
     */
    public function setSubscriberIdType($subscriberIdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ParamType::valueIsValid($subscriberIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ParamType', is_array($subscriberIdType) ? implode(', ', $subscriberIdType) : var_export($subscriberIdType, true), implode(', ', \EnumType\ParamType::getValidValues())), __LINE__);
        }
        $this->subscriberIdType = $subscriberIdType;
        return $this;
    }
    /**
     * Get userId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserId()
    {
        return isset($this->userId) ? $this->userId : null;
    }
    /**
     * Set userId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userId
     * @return \StructType\RedeemItemsBeta
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->userId);
        } else {
            $this->userId = $userId;
        }
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\RedeemItemsBeta
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Get purchaseOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPurchaseOrderItem|null
     */
    public function getPurchaseOrder()
    {
        return isset($this->purchaseOrder) ? $this->purchaseOrder : null;
    }
    /**
     * Set purchaseOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPurchaseOrderItem $purchaseOrder
     * @return \StructType\RedeemItemsBeta
     */
    public function setPurchaseOrder(\ArrayType\ArrayOfPurchaseOrderItem $purchaseOrder = null)
    {
        if (is_null($purchaseOrder) || (is_array($purchaseOrder) && empty($purchaseOrder))) {
            unset($this->purchaseOrder);
        } else {
            $this->purchaseOrder = $purchaseOrder;
        }
        return $this;
    }
    /**
     * Get deliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->deliveryAddress) ? $this->deliveryAddress : null;
    }
    /**
     * Set deliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddress
     * @return \StructType\RedeemItemsBeta
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->deliveryAddress);
        } else {
            $this->deliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get optionalLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOptionalLong()
    {
        return isset($this->optionalLong) ? $this->optionalLong : null;
    }
    /**
     * Set optionalLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $optionalLong
     * @return \StructType\RedeemItemsBeta
     */
    public function setOptionalLong($optionalLong = null)
    {
        // validation for constraint: int
        if (!is_null($optionalLong) && !(is_int($optionalLong) || ctype_digit($optionalLong))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionalLong, true), gettype($optionalLong)), __LINE__);
        }
        if (is_null($optionalLong) || (is_array($optionalLong) && empty($optionalLong))) {
            unset($this->optionalLong);
        } else {
            $this->optionalLong = $optionalLong;
        }
        return $this;
    }
    /**
     * Get optionalString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionalString()
    {
        return isset($this->optionalString) ? $this->optionalString : null;
    }
    /**
     * Set optionalString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionalString
     * @return \StructType\RedeemItemsBeta
     */
    public function setOptionalString($optionalString = null)
    {
        // validation for constraint: string
        if (!is_null($optionalString) && !is_string($optionalString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionalString, true), gettype($optionalString)), __LINE__);
        }
        if (is_null($optionalString) || (is_array($optionalString) && empty($optionalString))) {
            unset($this->optionalString);
        } else {
            $this->optionalString = $optionalString;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RedeemItemsBeta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
