<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PasswordRequestResponse StructType
 * @subpackage Structs
 */
class PasswordRequestResponse extends AbstractStructBase
{
    /**
     * The PasswordRequestResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApiResponse
     */
    public $PasswordRequestResult;
    /**
     * Constructor method for PasswordRequestResponse
     * @uses PasswordRequestResponse::setPasswordRequestResult()
     * @param \StructType\ApiResponse $passwordRequestResult
     */
    public function __construct(\StructType\ApiResponse $passwordRequestResult = null)
    {
        $this
            ->setPasswordRequestResult($passwordRequestResult);
    }
    /**
     * Get PasswordRequestResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApiResponse|null
     */
    public function getPasswordRequestResult()
    {
        return isset($this->PasswordRequestResult) ? $this->PasswordRequestResult : null;
    }
    /**
     * Set PasswordRequestResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ApiResponse $passwordRequestResult
     * @return \StructType\PasswordRequestResponse
     */
    public function setPasswordRequestResult(\StructType\ApiResponse $passwordRequestResult = null)
    {
        if (is_null($passwordRequestResult) || (is_array($passwordRequestResult) && empty($passwordRequestResult))) {
            unset($this->PasswordRequestResult);
        } else {
            $this->PasswordRequestResult = $passwordRequestResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PasswordRequestResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
