<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Error
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The ErrorLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorLevel;
    /**
     * The ErrorType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorType;
    /**
     * Constructor method for Error
     * @uses Error::setErrorCode()
     * @uses Error::setErrorDescription()
     * @uses Error::setErrorLevel()
     * @uses Error::setErrorType()
     * @param int $errorCode
     * @param string $errorDescription
     * @param string $errorLevel
     * @param string $errorType
     */
    public function __construct($errorCode = null, $errorDescription = null, $errorLevel = null, $errorType = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorDescription($errorDescription)
            ->setErrorLevel($errorLevel)
            ->setErrorType($errorType);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \StructType\Error
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \StructType\Error
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get ErrorLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorLevel()
    {
        return isset($this->ErrorLevel) ? $this->ErrorLevel : null;
    }
    /**
     * Set ErrorLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorLevel
     * @return \StructType\Error
     */
    public function setErrorLevel($errorLevel = null)
    {
        // validation for constraint: string
        if (!is_null($errorLevel) && !is_string($errorLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorLevel, true), gettype($errorLevel)), __LINE__);
        }
        if (is_null($errorLevel) || (is_array($errorLevel) && empty($errorLevel))) {
            unset($this->ErrorLevel);
        } else {
            $this->ErrorLevel = $errorLevel;
        }
        return $this;
    }
    /**
     * Get ErrorType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorType()
    {
        return isset($this->ErrorType) ? $this->ErrorType : null;
    }
    /**
     * Set ErrorType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorType
     * @return \StructType\Error
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: string
        if (!is_null($errorType) && !is_string($errorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorType, true), gettype($errorType)), __LINE__);
        }
        if (is_null($errorType) || (is_array($errorType) && empty($errorType))) {
            unset($this->ErrorType);
        } else {
            $this->ErrorType = $errorType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Error
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
