<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Redeemable ServiceType
 * @subpackage Services
 */
class Redeemable extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RedeemableItemDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RedeemableItemDetails $parameters
     * @return \StructType\RedeemableItemDetailsResponse|bool
     */
    public function RedeemableItemDetails(\StructType\RedeemableItemDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedeemableItemDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RedeemableItemDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
