<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deliver ServiceType
 * @subpackage Services
 */
class Deliver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeliverItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeliverItems $parameters
     * @return \StructType\DeliverItemsResponse|bool
     */
    public function DeliverItems(\StructType\DeliverItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeliverItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeliverItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
