<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRedeemItemCancel ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRedeemItemCancel
 * @subpackage Arrays
 */
class ArrayOfRedeemItemCancel extends AbstractStructArrayBase
{
    /**
     * The RedeemItemCancel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RedeemItemCancel[]
     */
    public $RedeemItemCancel;
    /**
     * Constructor method for ArrayOfRedeemItemCancel
     * @uses ArrayOfRedeemItemCancel::setRedeemItemCancel()
     * @param \StructType\RedeemItemCancel[] $redeemItemCancel
     */
    public function __construct(array $redeemItemCancel = array())
    {
        $this
            ->setRedeemItemCancel($redeemItemCancel);
    }
    /**
     * Get RedeemItemCancel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RedeemItemCancel[]|null
     */
    public function getRedeemItemCancel()
    {
        return isset($this->RedeemItemCancel) ? $this->RedeemItemCancel : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRedeemItemCancel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedeemItemCancel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedeemItemCancelForArrayConstraintsFromSetRedeemItemCancel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRedeemItemCancelRedeemItemCancelItem) {
            // validation for constraint: itemType
            if (!$arrayOfRedeemItemCancelRedeemItemCancelItem instanceof \StructType\RedeemItemCancel) {
                $invalidValues[] = is_object($arrayOfRedeemItemCancelRedeemItemCancelItem) ? get_class($arrayOfRedeemItemCancelRedeemItemCancelItem) : sprintf('%s(%s)', gettype($arrayOfRedeemItemCancelRedeemItemCancelItem), var_export($arrayOfRedeemItemCancelRedeemItemCancelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedeemItemCancel property can only contain items of type \StructType\RedeemItemCancel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedeemItemCancel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RedeemItemCancel[] $redeemItemCancel
     * @return \ArrayType\ArrayOfRedeemItemCancel
     */
    public function setRedeemItemCancel(array $redeemItemCancel = array())
    {
        // validation for constraint: array
        if ('' !== ($redeemItemCancelArrayErrorMessage = self::validateRedeemItemCancelForArrayConstraintsFromSetRedeemItemCancel($redeemItemCancel))) {
            throw new \InvalidArgumentException($redeemItemCancelArrayErrorMessage, __LINE__);
        }
        if (is_null($redeemItemCancel) || (is_array($redeemItemCancel) && empty($redeemItemCancel))) {
            unset($this->RedeemItemCancel);
        } else {
            $this->RedeemItemCancel = $redeemItemCancel;
        }
        return $this;
    }
    /**
     * Add item to RedeemItemCancel value
     * @throws \InvalidArgumentException
     * @param \StructType\RedeemItemCancel $item
     * @return \ArrayType\ArrayOfRedeemItemCancel
     */
    public function addToRedeemItemCancel(\StructType\RedeemItemCancel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RedeemItemCancel) {
            throw new \InvalidArgumentException(sprintf('The RedeemItemCancel property can only contain items of type \StructType\RedeemItemCancel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedeemItemCancel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RedeemItemCancel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RedeemItemCancel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RedeemItemCancel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RedeemItemCancel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RedeemItemCancel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RedeemItemCancel
     */
    public function getAttributeName()
    {
        return 'RedeemItemCancel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRedeemItemCancel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
