<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemQuantity ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfItemQuantity
 * @subpackage Arrays
 */
class ArrayOfItemQuantity extends AbstractStructArrayBase
{
    /**
     * The ItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemQuantity[]
     */
    public $ItemQuantity;
    /**
     * Constructor method for ArrayOfItemQuantity
     * @uses ArrayOfItemQuantity::setItemQuantity()
     * @param \StructType\ItemQuantity[] $itemQuantity
     */
    public function __construct(array $itemQuantity = array())
    {
        $this
            ->setItemQuantity($itemQuantity);
    }
    /**
     * Get ItemQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemQuantity[]|null
     */
    public function getItemQuantity()
    {
        return isset($this->ItemQuantity) ? $this->ItemQuantity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemQuantity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemQuantity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemQuantityForArrayConstraintsFromSetItemQuantity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemQuantityItemQuantityItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemQuantityItemQuantityItem instanceof \StructType\ItemQuantity) {
                $invalidValues[] = is_object($arrayOfItemQuantityItemQuantityItem) ? get_class($arrayOfItemQuantityItemQuantityItem) : sprintf('%s(%s)', gettype($arrayOfItemQuantityItemQuantityItem), var_export($arrayOfItemQuantityItemQuantityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemQuantity property can only contain items of type \StructType\ItemQuantity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemQuantity[] $itemQuantity
     * @return \ArrayType\ArrayOfItemQuantity
     */
    public function setItemQuantity(array $itemQuantity = array())
    {
        // validation for constraint: array
        if ('' !== ($itemQuantityArrayErrorMessage = self::validateItemQuantityForArrayConstraintsFromSetItemQuantity($itemQuantity))) {
            throw new \InvalidArgumentException($itemQuantityArrayErrorMessage, __LINE__);
        }
        if (is_null($itemQuantity) || (is_array($itemQuantity) && empty($itemQuantity))) {
            unset($this->ItemQuantity);
        } else {
            $this->ItemQuantity = $itemQuantity;
        }
        return $this;
    }
    /**
     * Add item to ItemQuantity value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemQuantity $item
     * @return \ArrayType\ArrayOfItemQuantity
     */
    public function addToItemQuantity(\StructType\ItemQuantity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemQuantity) {
            throw new \InvalidArgumentException(sprintf('The ItemQuantity property can only contain items of type \StructType\ItemQuantity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemQuantity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemQuantity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemQuantity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemQuantity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemQuantity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemQuantity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemQuantity
     */
    public function getAttributeName()
    {
        return 'ItemQuantity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
