<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stock Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Stock
 * @subpackage Structs
 * @date 2019-10-21
 */
class Stock extends AbstractStructBase
{
    /**
     * The AddDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddDatetime;
    /**
     * The ExternalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExternalReferenceId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The OptionalLong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OptionalLong;
    /**
     * The OptionalString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptionalString;
    /**
     * The PointOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointOrigin;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Points;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SourceId;
    /**
     * The ValidFromDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValidFromDatetime;
    /**
     * The ValidToDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDatetime;
    /**
     * Constructor method for Stock
     * @uses Stock::setAddDatetime()
     * @uses Stock::setExternalReferenceId()
     * @uses Stock::setId()
     * @uses Stock::setOptionalLong()
     * @uses Stock::setOptionalString()
     * @uses Stock::setPointOrigin()
     * @uses Stock::setPoints()
     * @uses Stock::setSourceId()
     * @uses Stock::setValidFromDatetime()
     * @uses Stock::setValidToDatetime()
     * @param string $addDatetime
     * @param int $externalReferenceId
     * @param int $id
     * @param int $optionalLong
     * @param string $optionalString
     * @param string $pointOrigin
     * @param int $points
     * @param int $sourceId
     * @param string $validFromDatetime
     * @param string $validToDatetime
     */
    public function __construct($addDatetime = null, $externalReferenceId = null, $id = null, $optionalLong = null, $optionalString = null, $pointOrigin = null, $points = null, $sourceId = null, $validFromDatetime = null, $validToDatetime = null)
    {
        $this
            ->setAddDatetime($addDatetime)
            ->setExternalReferenceId($externalReferenceId)
            ->setId($id)
            ->setOptionalLong($optionalLong)
            ->setOptionalString($optionalString)
            ->setPointOrigin($pointOrigin)
            ->setPoints($points)
            ->setSourceId($sourceId)
            ->setValidFromDatetime($validFromDatetime)
            ->setValidToDatetime($validToDatetime);
    }
    /**
     * Get AddDatetime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddDatetime()
    {
        return isset($this->AddDatetime) ? $this->AddDatetime : null;
    }
    /**
     * Set AddDatetime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addDatetime
     * @return \Struct\Stock
     */
    public function setAddDatetime($addDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($addDatetime) && !is_string($addDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addDatetime, true), gettype($addDatetime)), __LINE__);
        }
        if (is_null($addDatetime) || (is_array($addDatetime) && empty($addDatetime))) {
            unset($this->AddDatetime);
        } else {
            $this->AddDatetime = $addDatetime;
        }
        return $this;
    }
    /**
     * Get ExternalReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return isset($this->ExternalReferenceId) ? $this->ExternalReferenceId : null;
    }
    /**
     * Set ExternalReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalReferenceId
     * @return \Struct\Stock
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        if (is_null($externalReferenceId) || (is_array($externalReferenceId) && empty($externalReferenceId))) {
            unset($this->ExternalReferenceId);
        } else {
            $this->ExternalReferenceId = $externalReferenceId;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\Stock
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get OptionalLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOptionalLong()
    {
        return isset($this->OptionalLong) ? $this->OptionalLong : null;
    }
    /**
     * Set OptionalLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $optionalLong
     * @return \Struct\Stock
     */
    public function setOptionalLong($optionalLong = null)
    {
        // validation for constraint: int
        if (!is_null($optionalLong) && !(is_int($optionalLong) || ctype_digit($optionalLong))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionalLong, true), gettype($optionalLong)), __LINE__);
        }
        if (is_null($optionalLong) || (is_array($optionalLong) && empty($optionalLong))) {
            unset($this->OptionalLong);
        } else {
            $this->OptionalLong = $optionalLong;
        }
        return $this;
    }
    /**
     * Get OptionalString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionalString()
    {
        return isset($this->OptionalString) ? $this->OptionalString : null;
    }
    /**
     * Set OptionalString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionalString
     * @return \Struct\Stock
     */
    public function setOptionalString($optionalString = null)
    {
        // validation for constraint: string
        if (!is_null($optionalString) && !is_string($optionalString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionalString, true), gettype($optionalString)), __LINE__);
        }
        if (is_null($optionalString) || (is_array($optionalString) && empty($optionalString))) {
            unset($this->OptionalString);
        } else {
            $this->OptionalString = $optionalString;
        }
        return $this;
    }
    /**
     * Get PointOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointOrigin()
    {
        return isset($this->PointOrigin) ? $this->PointOrigin : null;
    }
    /**
     * Set PointOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointOrigin
     * @return \Struct\Stock
     */
    public function setPointOrigin($pointOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($pointOrigin) && !is_string($pointOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointOrigin, true), gettype($pointOrigin)), __LINE__);
        }
        if (is_null($pointOrigin) || (is_array($pointOrigin) && empty($pointOrigin))) {
            unset($this->PointOrigin);
        } else {
            $this->PointOrigin = $pointOrigin;
        }
        return $this;
    }
    /**
     * Get Points value
     * @return int|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param int $points
     * @return \Struct\Stock
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        $this->Points = $points;
        return $this;
    }
    /**
     * Get SourceId value
     * @return int|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param int $sourceId
     * @return \Struct\Stock
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceId) && !(is_int($sourceId) || ctype_digit($sourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get ValidFromDatetime value
     * @return string|null
     */
    public function getValidFromDatetime()
    {
        return $this->ValidFromDatetime;
    }
    /**
     * Set ValidFromDatetime value
     * @param string $validFromDatetime
     * @return \Struct\Stock
     */
    public function setValidFromDatetime($validFromDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDatetime) && !is_string($validFromDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDatetime, true), gettype($validFromDatetime)), __LINE__);
        }
        $this->ValidFromDatetime = $validFromDatetime;
        return $this;
    }
    /**
     * Get ValidToDatetime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDatetime()
    {
        return isset($this->ValidToDatetime) ? $this->ValidToDatetime : null;
    }
    /**
     * Set ValidToDatetime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDatetime
     * @return \Struct\Stock
     */
    public function setValidToDatetime($validToDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($validToDatetime) && !is_string($validToDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDatetime, true), gettype($validToDatetime)), __LINE__);
        }
        if (is_null($validToDatetime) || (is_array($validToDatetime) && empty($validToDatetime))) {
            unset($this->ValidToDatetime);
        } else {
            $this->ValidToDatetime = $validToDatetime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\Stock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
