<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionLog Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedemptionLog
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedemptionLog extends AbstractStructBase
{
    /**
     * The ChannelDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChannelDesc;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChannelId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerId;
    /**
     * The CustomerTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CustomerTypeId;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\Error
     */
    public $Error;
    /**
     * The FidelityLevelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FidelityLevelId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ItemsLogs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfRedemptionItemsLog
     */
    public $ItemsLogs;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RoleId;
    /**
     * The SendNotification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SendNotification;
    /**
     * The SourceDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceDesc;
    /**
     * The SourceExternalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SourceExternalReferenceId;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserId;
    /**
     * Constructor method for RedemptionLog
     * @uses RedemptionLog::setChannelDesc()
     * @uses RedemptionLog::setChannelId()
     * @uses RedemptionLog::setCustomerId()
     * @uses RedemptionLog::setCustomerTypeId()
     * @uses RedemptionLog::setDeliveryAddress()
     * @uses RedemptionLog::setError()
     * @uses RedemptionLog::setFidelityLevelId()
     * @uses RedemptionLog::setId()
     * @uses RedemptionLog::setItemsLogs()
     * @uses RedemptionLog::setRoleId()
     * @uses RedemptionLog::setSendNotification()
     * @uses RedemptionLog::setSourceDesc()
     * @uses RedemptionLog::setSourceExternalReferenceId()
     * @uses RedemptionLog::setSourceId()
     * @uses RedemptionLog::setUserId()
     * @param string $channelDesc
     * @param string $channelId
     * @param int $customerId
     * @param int $customerTypeId
     * @param string $deliveryAddress
     * @param \Struct\Error $error
     * @param int $fidelityLevelId
     * @param int $id
     * @param \Array\ArrayOfRedemptionItemsLog $itemsLogs
     * @param int $roleId
     * @param bool $sendNotification
     * @param string $sourceDesc
     * @param int $sourceExternalReferenceId
     * @param string $sourceId
     * @param int $userId
     */
    public function __construct($channelDesc = null, $channelId = null, $customerId = null, $customerTypeId = null, $deliveryAddress = null, \Struct\Error $error = null, $fidelityLevelId = null, $id = null, \Array\ArrayOfRedemptionItemsLog $itemsLogs = null, $roleId = null, $sendNotification = null, $sourceDesc = null, $sourceExternalReferenceId = null, $sourceId = null, $userId = null)
    {
        $this
            ->setChannelDesc($channelDesc)
            ->setChannelId($channelId)
            ->setCustomerId($customerId)
            ->setCustomerTypeId($customerTypeId)
            ->setDeliveryAddress($deliveryAddress)
            ->setError($error)
            ->setFidelityLevelId($fidelityLevelId)
            ->setId($id)
            ->setItemsLogs($itemsLogs)
            ->setRoleId($roleId)
            ->setSendNotification($sendNotification)
            ->setSourceDesc($sourceDesc)
            ->setSourceExternalReferenceId($sourceExternalReferenceId)
            ->setSourceId($sourceId)
            ->setUserId($userId);
    }
    /**
     * Get ChannelDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelDesc()
    {
        return isset($this->ChannelDesc) ? $this->ChannelDesc : null;
    }
    /**
     * Set ChannelDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelDesc
     * @return \Struct\RedemptionLog
     */
    public function setChannelDesc($channelDesc = null)
    {
        // validation for constraint: string
        if (!is_null($channelDesc) && !is_string($channelDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelDesc, true), gettype($channelDesc)), __LINE__);
        }
        if (is_null($channelDesc) || (is_array($channelDesc) && empty($channelDesc))) {
            unset($this->ChannelDesc);
        } else {
            $this->ChannelDesc = $channelDesc;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \Struct\RedemptionLog
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \Struct\RedemptionLog
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustomerTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCustomerTypeId()
    {
        return isset($this->CustomerTypeId) ? $this->CustomerTypeId : null;
    }
    /**
     * Set CustomerTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $customerTypeId
     * @return \Struct\RedemptionLog
     */
    public function setCustomerTypeId($customerTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($customerTypeId) && !(is_int($customerTypeId) || ctype_digit($customerTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerTypeId, true), gettype($customerTypeId)), __LINE__);
        }
        if (is_null($customerTypeId) || (is_array($customerTypeId) && empty($customerTypeId))) {
            unset($this->CustomerTypeId);
        } else {
            $this->CustomerTypeId = $customerTypeId;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->DeliveryAddress) ? $this->DeliveryAddress : null;
    }
    /**
     * Set DeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryAddress
     * @return \Struct\RedemptionLog
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->DeliveryAddress);
        } else {
            $this->DeliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\Error|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\Error $error
     * @return \Struct\RedemptionLog
     */
    public function setError(\Struct\Error $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get FidelityLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFidelityLevelId()
    {
        return isset($this->FidelityLevelId) ? $this->FidelityLevelId : null;
    }
    /**
     * Set FidelityLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fidelityLevelId
     * @return \Struct\RedemptionLog
     */
    public function setFidelityLevelId($fidelityLevelId = null)
    {
        // validation for constraint: int
        if (!is_null($fidelityLevelId) && !(is_int($fidelityLevelId) || ctype_digit($fidelityLevelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fidelityLevelId, true), gettype($fidelityLevelId)), __LINE__);
        }
        if (is_null($fidelityLevelId) || (is_array($fidelityLevelId) && empty($fidelityLevelId))) {
            unset($this->FidelityLevelId);
        } else {
            $this->FidelityLevelId = $fidelityLevelId;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\RedemptionLog
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ItemsLogs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfRedemptionItemsLog|null
     */
    public function getItemsLogs()
    {
        return isset($this->ItemsLogs) ? $this->ItemsLogs : null;
    }
    /**
     * Set ItemsLogs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfRedemptionItemsLog $itemsLogs
     * @return \Struct\RedemptionLog
     */
    public function setItemsLogs(\Array\ArrayOfRedemptionItemsLog $itemsLogs = null)
    {
        if (is_null($itemsLogs) || (is_array($itemsLogs) && empty($itemsLogs))) {
            unset($this->ItemsLogs);
        } else {
            $this->ItemsLogs = $itemsLogs;
        }
        return $this;
    }
    /**
     * Get RoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRoleId()
    {
        return isset($this->RoleId) ? $this->RoleId : null;
    }
    /**
     * Set RoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $roleId
     * @return \Struct\RedemptionLog
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: int
        if (!is_null($roleId) && !(is_int($roleId) || ctype_digit($roleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        if (is_null($roleId) || (is_array($roleId) && empty($roleId))) {
            unset($this->RoleId);
        } else {
            $this->RoleId = $roleId;
        }
        return $this;
    }
    /**
     * Get SendNotification value
     * @return bool|null
     */
    public function getSendNotification()
    {
        return $this->SendNotification;
    }
    /**
     * Set SendNotification value
     * @param bool $sendNotification
     * @return \Struct\RedemptionLog
     */
    public function setSendNotification($sendNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotification) && !is_bool($sendNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendNotification, true), gettype($sendNotification)), __LINE__);
        }
        $this->SendNotification = $sendNotification;
        return $this;
    }
    /**
     * Get SourceDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceDesc()
    {
        return isset($this->SourceDesc) ? $this->SourceDesc : null;
    }
    /**
     * Set SourceDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceDesc
     * @return \Struct\RedemptionLog
     */
    public function setSourceDesc($sourceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($sourceDesc) && !is_string($sourceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceDesc, true), gettype($sourceDesc)), __LINE__);
        }
        if (is_null($sourceDesc) || (is_array($sourceDesc) && empty($sourceDesc))) {
            unset($this->SourceDesc);
        } else {
            $this->SourceDesc = $sourceDesc;
        }
        return $this;
    }
    /**
     * Get SourceExternalReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSourceExternalReferenceId()
    {
        return isset($this->SourceExternalReferenceId) ? $this->SourceExternalReferenceId : null;
    }
    /**
     * Set SourceExternalReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sourceExternalReferenceId
     * @return \Struct\RedemptionLog
     */
    public function setSourceExternalReferenceId($sourceExternalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceExternalReferenceId) && !(is_int($sourceExternalReferenceId) || ctype_digit($sourceExternalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceExternalReferenceId, true), gettype($sourceExternalReferenceId)), __LINE__);
        }
        if (is_null($sourceExternalReferenceId) || (is_array($sourceExternalReferenceId) && empty($sourceExternalReferenceId))) {
            unset($this->SourceExternalReferenceId);
        } else {
            $this->SourceExternalReferenceId = $sourceExternalReferenceId;
        }
        return $this;
    }
    /**
     * Get SourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceId()
    {
        return isset($this->SourceId) ? $this->SourceId : null;
    }
    /**
     * Set SourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceId
     * @return \Struct\RedemptionLog
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->SourceId);
        } else {
            $this->SourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * @return int|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \Struct\RedemptionLog
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedemptionLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
