<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionItemPointsLog Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedemptionItemPointsLog
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedemptionItemPointsLog extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerId;
    /**
     * The ExternalReferenceid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExternalReferenceid;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Points;
    /**
     * The RedemptionitemLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedemptionitemLogId;
    /**
     * The SourceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SourceId;
    /**
     * The ValidFromDatetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDatetime;
    /**
     * The ValidToDatetim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDatetim;
    /**
     * Constructor method for RedemptionItemPointsLog
     * @uses RedemptionItemPointsLog::setCustomerId()
     * @uses RedemptionItemPointsLog::setExternalReferenceid()
     * @uses RedemptionItemPointsLog::setId()
     * @uses RedemptionItemPointsLog::setPoints()
     * @uses RedemptionItemPointsLog::setRedemptionitemLogId()
     * @uses RedemptionItemPointsLog::setSourceId()
     * @uses RedemptionItemPointsLog::setValidFromDatetime()
     * @uses RedemptionItemPointsLog::setValidToDatetim()
     * @param int $customerId
     * @param int $externalReferenceid
     * @param int $id
     * @param int $points
     * @param int $redemptionitemLogId
     * @param string $sourceId
     * @param string $validFromDatetime
     * @param string $validToDatetim
     */
    public function __construct($customerId = null, $externalReferenceid = null, $id = null, $points = null, $redemptionitemLogId = null, $sourceId = null, $validFromDatetime = null, $validToDatetim = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setExternalReferenceid($externalReferenceid)
            ->setId($id)
            ->setPoints($points)
            ->setRedemptionitemLogId($redemptionitemLogId)
            ->setSourceId($sourceId)
            ->setValidFromDatetime($validFromDatetime)
            ->setValidToDatetim($validToDatetim);
    }
    /**
     * Get CustomerId value
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ExternalReferenceid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExternalReferenceid()
    {
        return isset($this->ExternalReferenceid) ? $this->ExternalReferenceid : null;
    }
    /**
     * Set ExternalReferenceid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $externalReferenceid
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setExternalReferenceid($externalReferenceid = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceid) && !(is_int($externalReferenceid) || ctype_digit($externalReferenceid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceid, true), gettype($externalReferenceid)), __LINE__);
        }
        if (is_null($externalReferenceid) || (is_array($externalReferenceid) && empty($externalReferenceid))) {
            unset($this->ExternalReferenceid);
        } else {
            $this->ExternalReferenceid = $externalReferenceid;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Points value
     * @return int|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param int $points
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        $this->Points = $points;
        return $this;
    }
    /**
     * Get RedemptionitemLogId value
     * @return int|null
     */
    public function getRedemptionitemLogId()
    {
        return $this->RedemptionitemLogId;
    }
    /**
     * Set RedemptionitemLogId value
     * @param int $redemptionitemLogId
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setRedemptionitemLogId($redemptionitemLogId = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionitemLogId) && !(is_int($redemptionitemLogId) || ctype_digit($redemptionitemLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionitemLogId, true), gettype($redemptionitemLogId)), __LINE__);
        }
        $this->RedemptionitemLogId = $redemptionitemLogId;
        return $this;
    }
    /**
     * Get SourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->SourceId;
    }
    /**
     * Set SourceId value
     * @param string $sourceId
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceId) && !is_string($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceId, true), gettype($sourceId)), __LINE__);
        }
        $this->SourceId = $sourceId;
        return $this;
    }
    /**
     * Get ValidFromDatetime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDatetime()
    {
        return isset($this->ValidFromDatetime) ? $this->ValidFromDatetime : null;
    }
    /**
     * Set ValidFromDatetime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDatetime
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setValidFromDatetime($validFromDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDatetime) && !is_string($validFromDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDatetime, true), gettype($validFromDatetime)), __LINE__);
        }
        if (is_null($validFromDatetime) || (is_array($validFromDatetime) && empty($validFromDatetime))) {
            unset($this->ValidFromDatetime);
        } else {
            $this->ValidFromDatetime = $validFromDatetime;
        }
        return $this;
    }
    /**
     * Get ValidToDatetim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDatetim()
    {
        return isset($this->ValidToDatetim) ? $this->ValidToDatetim : null;
    }
    /**
     * Set ValidToDatetim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDatetim
     * @return \Struct\RedemptionItemPointsLog
     */
    public function setValidToDatetim($validToDatetim = null)
    {
        // validation for constraint: string
        if (!is_null($validToDatetim) && !is_string($validToDatetim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDatetim, true), gettype($validToDatetim)), __LINE__);
        }
        if (is_null($validToDatetim) || (is_array($validToDatetim) && empty($validToDatetim))) {
            unset($this->ValidToDatetim);
        } else {
            $this->ValidToDatetim = $validToDatetim;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedemptionItemPointsLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
