<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionHistory Struct
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedemptionHistory extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The externalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalReferenceId;
    /**
     * The subscriberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberId;
    /**
     * The subscriberIdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberIdType;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $userId;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The walletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $walletType;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $endDate;
    /**
     * The lastNumberOfItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $lastNumberOfItems;
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $orderId;
    /**
     * The includeFailedRedemptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeFailedRedemptions;
    /**
     * Constructor method for RedemptionHistory
     * @uses RedemptionHistory::setSource()
     * @uses RedemptionHistory::setChannel()
     * @uses RedemptionHistory::setExternalReferenceId()
     * @uses RedemptionHistory::setSubscriberId()
     * @uses RedemptionHistory::setSubscriberIdType()
     * @uses RedemptionHistory::setUserId()
     * @uses RedemptionHistory::setLanguage()
     * @uses RedemptionHistory::setWalletType()
     * @uses RedemptionHistory::setStartDate()
     * @uses RedemptionHistory::setEndDate()
     * @uses RedemptionHistory::setLastNumberOfItems()
     * @uses RedemptionHistory::setOrderId()
     * @uses RedemptionHistory::setIncludeFailedRedemptions()
     * @param string $source
     * @param string $channel
     * @param int $externalReferenceId
     * @param string $subscriberId
     * @param string $subscriberIdType
     * @param int $userId
     * @param string $language
     * @param string $walletType
     * @param string $startDate
     * @param string $endDate
     * @param int $lastNumberOfItems
     * @param int $orderId
     * @param bool $includeFailedRedemptions
     */
    public function __construct($source = null, $channel = null, $externalReferenceId = null, $subscriberId = null, $subscriberIdType = null, $userId = null, $language = null, $walletType = null, $startDate = null, $endDate = null, $lastNumberOfItems = null, $orderId = null, $includeFailedRedemptions = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setExternalReferenceId($externalReferenceId)
            ->setSubscriberId($subscriberId)
            ->setSubscriberIdType($subscriberIdType)
            ->setUserId($userId)
            ->setLanguage($language)
            ->setWalletType($walletType)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setLastNumberOfItems($lastNumberOfItems)
            ->setOrderId($orderId)
            ->setIncludeFailedRedemptions($includeFailedRedemptions);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \Struct\RedemptionHistory
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \Struct\RedemptionHistory
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get externalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->externalReferenceId;
    }
    /**
     * Set externalReferenceId value
     * @param int $externalReferenceId
     * @return \Struct\RedemptionHistory
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->externalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get subscriberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberId()
    {
        return isset($this->subscriberId) ? $this->subscriberId : null;
    }
    /**
     * Set subscriberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberId
     * @return \Struct\RedemptionHistory
     */
    public function setSubscriberId($subscriberId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberId) && !is_string($subscriberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberId, true), gettype($subscriberId)), __LINE__);
        }
        if (is_null($subscriberId) || (is_array($subscriberId) && empty($subscriberId))) {
            unset($this->subscriberId);
        } else {
            $this->subscriberId = $subscriberId;
        }
        return $this;
    }
    /**
     * Get subscriberIdType value
     * @return string|null
     */
    public function getSubscriberIdType()
    {
        return $this->subscriberIdType;
    }
    /**
     * Set subscriberIdType value
     * @uses \Enum\ParamType::valueIsValid()
     * @uses \Enum\ParamType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberIdType
     * @return \Struct\RedemptionHistory
     */
    public function setSubscriberIdType($subscriberIdType = null)
    {
        // validation for constraint: enumeration
        if (!\Enum\ParamType::valueIsValid($subscriberIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enum\ParamType', is_array($subscriberIdType) ? implode(', ', $subscriberIdType) : var_export($subscriberIdType, true), implode(', ', \Enum\ParamType::getValidValues())), __LINE__);
        }
        $this->subscriberIdType = $subscriberIdType;
        return $this;
    }
    /**
     * Get userId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserId()
    {
        return isset($this->userId) ? $this->userId : null;
    }
    /**
     * Set userId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userId
     * @return \Struct\RedemptionHistory
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->userId);
        } else {
            $this->userId = $userId;
        }
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \Struct\RedemptionHistory
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Get walletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWalletType()
    {
        return isset($this->walletType) ? $this->walletType : null;
    }
    /**
     * Set walletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $walletType
     * @return \Struct\RedemptionHistory
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->walletType);
        } else {
            $this->walletType = $walletType;
        }
        return $this;
    }
    /**
     * Get startDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->startDate) ? $this->startDate : null;
    }
    /**
     * Set startDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \Struct\RedemptionHistory
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->startDate);
        } else {
            $this->startDate = $startDate;
        }
        return $this;
    }
    /**
     * Get endDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->endDate) ? $this->endDate : null;
    }
    /**
     * Set endDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \Struct\RedemptionHistory
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->endDate);
        } else {
            $this->endDate = $endDate;
        }
        return $this;
    }
    /**
     * Get lastNumberOfItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastNumberOfItems()
    {
        return isset($this->lastNumberOfItems) ? $this->lastNumberOfItems : null;
    }
    /**
     * Set lastNumberOfItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastNumberOfItems
     * @return \Struct\RedemptionHistory
     */
    public function setLastNumberOfItems($lastNumberOfItems = null)
    {
        // validation for constraint: int
        if (!is_null($lastNumberOfItems) && !(is_int($lastNumberOfItems) || ctype_digit($lastNumberOfItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastNumberOfItems, true), gettype($lastNumberOfItems)), __LINE__);
        }
        if (is_null($lastNumberOfItems) || (is_array($lastNumberOfItems) && empty($lastNumberOfItems))) {
            unset($this->lastNumberOfItems);
        } else {
            $this->lastNumberOfItems = $lastNumberOfItems;
        }
        return $this;
    }
    /**
     * Get orderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderId()
    {
        return isset($this->orderId) ? $this->orderId : null;
    }
    /**
     * Set orderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderId
     * @return \Struct\RedemptionHistory
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->orderId);
        } else {
            $this->orderId = $orderId;
        }
        return $this;
    }
    /**
     * Get includeFailedRedemptions value
     * @return bool|null
     */
    public function getIncludeFailedRedemptions()
    {
        return $this->includeFailedRedemptions;
    }
    /**
     * Set includeFailedRedemptions value
     * @param bool $includeFailedRedemptions
     * @return \Struct\RedemptionHistory
     */
    public function setIncludeFailedRedemptions($includeFailedRedemptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFailedRedemptions) && !is_bool($includeFailedRedemptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFailedRedemptions, true), gettype($includeFailedRedemptions)), __LINE__);
        }
        $this->includeFailedRedemptions = $includeFailedRedemptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedemptionHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
