<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItemCategory Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemableItemCategory
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedeemableItemCategory extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The RedeemableItemCategoryCatalogue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\RedeemableItemCatalogue
     */
    public $RedeemableItemCategoryCatalogue;
    /**
     * The RedeemableItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfRedeemableItem
     */
    public $RedeemableItems;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDescription;
    /**
     * Constructor method for RedeemableItemCategory
     * @uses RedeemableItemCategory::setDescription()
     * @uses RedeemableItemCategory::setId()
     * @uses RedeemableItemCategory::setRedeemableItemCategoryCatalogue()
     * @uses RedeemableItemCategory::setRedeemableItems()
     * @uses RedeemableItemCategory::setShortDescription()
     * @param string $description
     * @param int $id
     * @param \Struct\RedeemableItemCatalogue $redeemableItemCategoryCatalogue
     * @param \Array\ArrayOfRedeemableItem $redeemableItems
     * @param string $shortDescription
     */
    public function __construct($description = null, $id = null, \Struct\RedeemableItemCatalogue $redeemableItemCategoryCatalogue = null, \Array\ArrayOfRedeemableItem $redeemableItems = null, $shortDescription = null)
    {
        $this
            ->setDescription($description)
            ->setId($id)
            ->setRedeemableItemCategoryCatalogue($redeemableItemCategoryCatalogue)
            ->setRedeemableItems($redeemableItems)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Struct\RedeemableItemCategory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\RedeemableItemCategory
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RedeemableItemCategoryCatalogue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\RedeemableItemCatalogue|null
     */
    public function getRedeemableItemCategoryCatalogue()
    {
        return isset($this->RedeemableItemCategoryCatalogue) ? $this->RedeemableItemCategoryCatalogue : null;
    }
    /**
     * Set RedeemableItemCategoryCatalogue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\RedeemableItemCatalogue $redeemableItemCategoryCatalogue
     * @return \Struct\RedeemableItemCategory
     */
    public function setRedeemableItemCategoryCatalogue(\Struct\RedeemableItemCatalogue $redeemableItemCategoryCatalogue = null)
    {
        if (is_null($redeemableItemCategoryCatalogue) || (is_array($redeemableItemCategoryCatalogue) && empty($redeemableItemCategoryCatalogue))) {
            unset($this->RedeemableItemCategoryCatalogue);
        } else {
            $this->RedeemableItemCategoryCatalogue = $redeemableItemCategoryCatalogue;
        }
        return $this;
    }
    /**
     * Get RedeemableItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfRedeemableItem|null
     */
    public function getRedeemableItems()
    {
        return isset($this->RedeemableItems) ? $this->RedeemableItems : null;
    }
    /**
     * Set RedeemableItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfRedeemableItem $redeemableItems
     * @return \Struct\RedeemableItemCategory
     */
    public function setRedeemableItems(\Array\ArrayOfRedeemableItem $redeemableItems = null)
    {
        if (is_null($redeemableItems) || (is_array($redeemableItems) && empty($redeemableItems))) {
            unset($this->RedeemableItems);
        } else {
            $this->RedeemableItems = $redeemableItems;
        }
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDescription
     * @return \Struct\RedeemableItemCategory
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedeemableItemCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
