<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryStockPoints Struct
 * @subpackage Structs
 * @date 2019-10-21
 */
class QueryStockPoints extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The externalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalReferenceId;
    /**
     * The subscriberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberId;
    /**
     * The subscriberIdType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberIdType;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $userId;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The includeNotYetValidPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeNotYetValidPoints;
    /**
     * The walletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $walletType;
    /**
     * The pointOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pointOrigin;
    /**
     * The optionalLong
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $optionalLong;
    /**
     * The optionalString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $optionalString;
    /**
     * Constructor method for QueryStockPoints
     * @uses QueryStockPoints::setSource()
     * @uses QueryStockPoints::setChannel()
     * @uses QueryStockPoints::setExternalReferenceId()
     * @uses QueryStockPoints::setSubscriberId()
     * @uses QueryStockPoints::setSubscriberIdType()
     * @uses QueryStockPoints::setUserId()
     * @uses QueryStockPoints::setLanguage()
     * @uses QueryStockPoints::setIncludeNotYetValidPoints()
     * @uses QueryStockPoints::setWalletType()
     * @uses QueryStockPoints::setPointOrigin()
     * @uses QueryStockPoints::setOptionalLong()
     * @uses QueryStockPoints::setOptionalString()
     * @param string $source
     * @param string $channel
     * @param int $externalReferenceId
     * @param string $subscriberId
     * @param string $subscriberIdType
     * @param int $userId
     * @param string $language
     * @param bool $includeNotYetValidPoints
     * @param string $walletType
     * @param string $pointOrigin
     * @param int $optionalLong
     * @param string $optionalString
     */
    public function __construct($source = null, $channel = null, $externalReferenceId = null, $subscriberId = null, $subscriberIdType = null, $userId = null, $language = null, $includeNotYetValidPoints = null, $walletType = null, $pointOrigin = null, $optionalLong = null, $optionalString = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setExternalReferenceId($externalReferenceId)
            ->setSubscriberId($subscriberId)
            ->setSubscriberIdType($subscriberIdType)
            ->setUserId($userId)
            ->setLanguage($language)
            ->setIncludeNotYetValidPoints($includeNotYetValidPoints)
            ->setWalletType($walletType)
            ->setPointOrigin($pointOrigin)
            ->setOptionalLong($optionalLong)
            ->setOptionalString($optionalString);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \Struct\QueryStockPoints
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \Struct\QueryStockPoints
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get externalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->externalReferenceId;
    }
    /**
     * Set externalReferenceId value
     * @param int $externalReferenceId
     * @return \Struct\QueryStockPoints
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->externalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get subscriberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberId()
    {
        return isset($this->subscriberId) ? $this->subscriberId : null;
    }
    /**
     * Set subscriberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberId
     * @return \Struct\QueryStockPoints
     */
    public function setSubscriberId($subscriberId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberId) && !is_string($subscriberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberId, true), gettype($subscriberId)), __LINE__);
        }
        if (is_null($subscriberId) || (is_array($subscriberId) && empty($subscriberId))) {
            unset($this->subscriberId);
        } else {
            $this->subscriberId = $subscriberId;
        }
        return $this;
    }
    /**
     * Get subscriberIdType value
     * @return string|null
     */
    public function getSubscriberIdType()
    {
        return $this->subscriberIdType;
    }
    /**
     * Set subscriberIdType value
     * @uses \Enum\ParamType::valueIsValid()
     * @uses \Enum\ParamType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberIdType
     * @return \Struct\QueryStockPoints
     */
    public function setSubscriberIdType($subscriberIdType = null)
    {
        // validation for constraint: enumeration
        if (!\Enum\ParamType::valueIsValid($subscriberIdType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enum\ParamType', is_array($subscriberIdType) ? implode(', ', $subscriberIdType) : var_export($subscriberIdType, true), implode(', ', \Enum\ParamType::getValidValues())), __LINE__);
        }
        $this->subscriberIdType = $subscriberIdType;
        return $this;
    }
    /**
     * Get userId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserId()
    {
        return isset($this->userId) ? $this->userId : null;
    }
    /**
     * Set userId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userId
     * @return \Struct\QueryStockPoints
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !(is_int($userId) || ctype_digit($userId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->userId);
        } else {
            $this->userId = $userId;
        }
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \Struct\QueryStockPoints
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Get includeNotYetValidPoints value
     * @return bool|null
     */
    public function getIncludeNotYetValidPoints()
    {
        return $this->includeNotYetValidPoints;
    }
    /**
     * Set includeNotYetValidPoints value
     * @param bool $includeNotYetValidPoints
     * @return \Struct\QueryStockPoints
     */
    public function setIncludeNotYetValidPoints($includeNotYetValidPoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeNotYetValidPoints) && !is_bool($includeNotYetValidPoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNotYetValidPoints, true), gettype($includeNotYetValidPoints)), __LINE__);
        }
        $this->includeNotYetValidPoints = $includeNotYetValidPoints;
        return $this;
    }
    /**
     * Get walletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWalletType()
    {
        return isset($this->walletType) ? $this->walletType : null;
    }
    /**
     * Set walletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $walletType
     * @return \Struct\QueryStockPoints
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->walletType);
        } else {
            $this->walletType = $walletType;
        }
        return $this;
    }
    /**
     * Get pointOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointOrigin()
    {
        return isset($this->pointOrigin) ? $this->pointOrigin : null;
    }
    /**
     * Set pointOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointOrigin
     * @return \Struct\QueryStockPoints
     */
    public function setPointOrigin($pointOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($pointOrigin) && !is_string($pointOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointOrigin, true), gettype($pointOrigin)), __LINE__);
        }
        if (is_null($pointOrigin) || (is_array($pointOrigin) && empty($pointOrigin))) {
            unset($this->pointOrigin);
        } else {
            $this->pointOrigin = $pointOrigin;
        }
        return $this;
    }
    /**
     * Get optionalLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOptionalLong()
    {
        return isset($this->optionalLong) ? $this->optionalLong : null;
    }
    /**
     * Set optionalLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $optionalLong
     * @return \Struct\QueryStockPoints
     */
    public function setOptionalLong($optionalLong = null)
    {
        // validation for constraint: int
        if (!is_null($optionalLong) && !(is_int($optionalLong) || ctype_digit($optionalLong))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionalLong, true), gettype($optionalLong)), __LINE__);
        }
        if (is_null($optionalLong) || (is_array($optionalLong) && empty($optionalLong))) {
            unset($this->optionalLong);
        } else {
            $this->optionalLong = $optionalLong;
        }
        return $this;
    }
    /**
     * Get optionalString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptionalString()
    {
        return isset($this->optionalString) ? $this->optionalString : null;
    }
    /**
     * Set optionalString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optionalString
     * @return \Struct\QueryStockPoints
     */
    public function setOptionalString($optionalString = null)
    {
        // validation for constraint: string
        if (!is_null($optionalString) && !is_string($optionalString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionalString, true), gettype($optionalString)), __LINE__);
        }
        if (is_null($optionalString) || (is_array($optionalString) && empty($optionalString))) {
            unset($this->optionalString);
        } else {
            $this->optionalString = $optionalString;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\QueryStockPoints
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
