<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersSummaryResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrdersSummaryResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class OrdersSummaryResponse extends ApiResponse
{
    /**
     * The PhysicalProductsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalProductsNumber;
    /**
     * The PointsUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PointsUsed;
    /**
     * The ProductsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductsNumber;
    /**
     * The TelecomProductsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TelecomProductsNumber;
    /**
     * Constructor method for OrdersSummaryResponse
     * @uses OrdersSummaryResponse::setPhysicalProductsNumber()
     * @uses OrdersSummaryResponse::setPointsUsed()
     * @uses OrdersSummaryResponse::setProductsNumber()
     * @uses OrdersSummaryResponse::setTelecomProductsNumber()
     * @param int $physicalProductsNumber
     * @param int $pointsUsed
     * @param int $productsNumber
     * @param int $telecomProductsNumber
     */
    public function __construct($physicalProductsNumber = null, $pointsUsed = null, $productsNumber = null, $telecomProductsNumber = null)
    {
        $this
            ->setPhysicalProductsNumber($physicalProductsNumber)
            ->setPointsUsed($pointsUsed)
            ->setProductsNumber($productsNumber)
            ->setTelecomProductsNumber($telecomProductsNumber);
    }
    /**
     * Get PhysicalProductsNumber value
     * @return int|null
     */
    public function getPhysicalProductsNumber()
    {
        return $this->PhysicalProductsNumber;
    }
    /**
     * Set PhysicalProductsNumber value
     * @param int $physicalProductsNumber
     * @return \Struct\OrdersSummaryResponse
     */
    public function setPhysicalProductsNumber($physicalProductsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($physicalProductsNumber) && !(is_int($physicalProductsNumber) || ctype_digit($physicalProductsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalProductsNumber, true), gettype($physicalProductsNumber)), __LINE__);
        }
        $this->PhysicalProductsNumber = $physicalProductsNumber;
        return $this;
    }
    /**
     * Get PointsUsed value
     * @return int|null
     */
    public function getPointsUsed()
    {
        return $this->PointsUsed;
    }
    /**
     * Set PointsUsed value
     * @param int $pointsUsed
     * @return \Struct\OrdersSummaryResponse
     */
    public function setPointsUsed($pointsUsed = null)
    {
        // validation for constraint: int
        if (!is_null($pointsUsed) && !(is_int($pointsUsed) || ctype_digit($pointsUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pointsUsed, true), gettype($pointsUsed)), __LINE__);
        }
        $this->PointsUsed = $pointsUsed;
        return $this;
    }
    /**
     * Get ProductsNumber value
     * @return int|null
     */
    public function getProductsNumber()
    {
        return $this->ProductsNumber;
    }
    /**
     * Set ProductsNumber value
     * @param int $productsNumber
     * @return \Struct\OrdersSummaryResponse
     */
    public function setProductsNumber($productsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($productsNumber) && !(is_int($productsNumber) || ctype_digit($productsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productsNumber, true), gettype($productsNumber)), __LINE__);
        }
        $this->ProductsNumber = $productsNumber;
        return $this;
    }
    /**
     * Get TelecomProductsNumber value
     * @return int|null
     */
    public function getTelecomProductsNumber()
    {
        return $this->TelecomProductsNumber;
    }
    /**
     * Set TelecomProductsNumber value
     * @param int $telecomProductsNumber
     * @return \Struct\OrdersSummaryResponse
     */
    public function setTelecomProductsNumber($telecomProductsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($telecomProductsNumber) && !(is_int($telecomProductsNumber) || ctype_digit($telecomProductsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($telecomProductsNumber, true), gettype($telecomProductsNumber)), __LINE__);
        }
        $this->TelecomProductsNumber = $telecomProductsNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\OrdersSummaryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
