<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NextRedemptionDateResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NextRedemptionDateResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class NextRedemptionDateResponse extends ApiResponse
{
    /**
     * The NextRedemptionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NextRedemptionDate;
    /**
     * The NextRedemptionInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NextRedemptionInDays;
    /**
     * Constructor method for NextRedemptionDateResponse
     * @uses NextRedemptionDateResponse::setNextRedemptionDate()
     * @uses NextRedemptionDateResponse::setNextRedemptionInDays()
     * @param string $nextRedemptionDate
     * @param int $nextRedemptionInDays
     */
    public function __construct($nextRedemptionDate = null, $nextRedemptionInDays = null)
    {
        $this
            ->setNextRedemptionDate($nextRedemptionDate)
            ->setNextRedemptionInDays($nextRedemptionInDays);
    }
    /**
     * Get NextRedemptionDate value
     * @return string|null
     */
    public function getNextRedemptionDate()
    {
        return $this->NextRedemptionDate;
    }
    /**
     * Set NextRedemptionDate value
     * @param string $nextRedemptionDate
     * @return \Struct\NextRedemptionDateResponse
     */
    public function setNextRedemptionDate($nextRedemptionDate = null)
    {
        // validation for constraint: string
        if (!is_null($nextRedemptionDate) && !is_string($nextRedemptionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextRedemptionDate, true), gettype($nextRedemptionDate)), __LINE__);
        }
        $this->NextRedemptionDate = $nextRedemptionDate;
        return $this;
    }
    /**
     * Get NextRedemptionInDays value
     * @return int|null
     */
    public function getNextRedemptionInDays()
    {
        return $this->NextRedemptionInDays;
    }
    /**
     * Set NextRedemptionInDays value
     * @param int $nextRedemptionInDays
     * @return \Struct\NextRedemptionDateResponse
     */
    public function setNextRedemptionInDays($nextRedemptionInDays = null)
    {
        // validation for constraint: int
        if (!is_null($nextRedemptionInDays) && !(is_int($nextRedemptionInDays) || ctype_digit($nextRedemptionInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextRedemptionInDays, true), gettype($nextRedemptionInDays)), __LINE__);
        }
        $this->NextRedemptionInDays = $nextRedemptionInDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\NextRedemptionDateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
