<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Customer
 * @subpackage Structs
 * @date 2019-10-21
 */
class Customer extends AbstractStructBase
{
    /**
     * The ContractNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContractNo;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerId;
    /**
     * The CustomerTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerTypeId;
    /**
     * The FidelityLevelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FidelityLevelId;
    /**
     * The LanguageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LanguageId;
    /**
     * The Msisdn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Msisdn;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RoleId;
    /**
     * The UserTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserTypeId;
    /**
     * Constructor method for Customer
     * @uses Customer::setContractNo()
     * @uses Customer::setCustomerId()
     * @uses Customer::setCustomerTypeId()
     * @uses Customer::setFidelityLevelId()
     * @uses Customer::setLanguageId()
     * @uses Customer::setMsisdn()
     * @uses Customer::setRoleId()
     * @uses Customer::setUserTypeId()
     * @param string $contractNo
     * @param int $customerId
     * @param int $customerTypeId
     * @param int $fidelityLevelId
     * @param int $languageId
     * @param string $msisdn
     * @param int $roleId
     * @param int $userTypeId
     */
    public function __construct($contractNo = null, $customerId = null, $customerTypeId = null, $fidelityLevelId = null, $languageId = null, $msisdn = null, $roleId = null, $userTypeId = null)
    {
        $this
            ->setContractNo($contractNo)
            ->setCustomerId($customerId)
            ->setCustomerTypeId($customerTypeId)
            ->setFidelityLevelId($fidelityLevelId)
            ->setLanguageId($languageId)
            ->setMsisdn($msisdn)
            ->setRoleId($roleId)
            ->setUserTypeId($userTypeId);
    }
    /**
     * Get ContractNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractNo()
    {
        return isset($this->ContractNo) ? $this->ContractNo : null;
    }
    /**
     * Set ContractNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractNo
     * @return \Struct\Customer
     */
    public function setContractNo($contractNo = null)
    {
        // validation for constraint: string
        if (!is_null($contractNo) && !is_string($contractNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNo, true), gettype($contractNo)), __LINE__);
        }
        if (is_null($contractNo) || (is_array($contractNo) && empty($contractNo))) {
            unset($this->ContractNo);
        } else {
            $this->ContractNo = $contractNo;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \Struct\Customer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get CustomerTypeId value
     * @return int|null
     */
    public function getCustomerTypeId()
    {
        return $this->CustomerTypeId;
    }
    /**
     * Set CustomerTypeId value
     * @param int $customerTypeId
     * @return \Struct\Customer
     */
    public function setCustomerTypeId($customerTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($customerTypeId) && !(is_int($customerTypeId) || ctype_digit($customerTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerTypeId, true), gettype($customerTypeId)), __LINE__);
        }
        $this->CustomerTypeId = $customerTypeId;
        return $this;
    }
    /**
     * Get FidelityLevelId value
     * @return int|null
     */
    public function getFidelityLevelId()
    {
        return $this->FidelityLevelId;
    }
    /**
     * Set FidelityLevelId value
     * @param int $fidelityLevelId
     * @return \Struct\Customer
     */
    public function setFidelityLevelId($fidelityLevelId = null)
    {
        // validation for constraint: int
        if (!is_null($fidelityLevelId) && !(is_int($fidelityLevelId) || ctype_digit($fidelityLevelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fidelityLevelId, true), gettype($fidelityLevelId)), __LINE__);
        }
        $this->FidelityLevelId = $fidelityLevelId;
        return $this;
    }
    /**
     * Get LanguageId value
     * @return int|null
     */
    public function getLanguageId()
    {
        return $this->LanguageId;
    }
    /**
     * Set LanguageId value
     * @param int $languageId
     * @return \Struct\Customer
     */
    public function setLanguageId($languageId = null)
    {
        // validation for constraint: int
        if (!is_null($languageId) && !(is_int($languageId) || ctype_digit($languageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($languageId, true), gettype($languageId)), __LINE__);
        }
        $this->LanguageId = $languageId;
        return $this;
    }
    /**
     * Get Msisdn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsisdn()
    {
        return isset($this->Msisdn) ? $this->Msisdn : null;
    }
    /**
     * Set Msisdn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msisdn
     * @return \Struct\Customer
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msisdn, true), gettype($msisdn)), __LINE__);
        }
        if (is_null($msisdn) || (is_array($msisdn) && empty($msisdn))) {
            unset($this->Msisdn);
        } else {
            $this->Msisdn = $msisdn;
        }
        return $this;
    }
    /**
     * Get RoleId value
     * @return int|null
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param int $roleId
     * @return \Struct\Customer
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: int
        if (!is_null($roleId) && !(is_int($roleId) || ctype_digit($roleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Get UserTypeId value
     * @return int|null
     */
    public function getUserTypeId()
    {
        return $this->UserTypeId;
    }
    /**
     * Set UserTypeId value
     * @param int $userTypeId
     * @return \Struct\Customer
     */
    public function setUserTypeId($userTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($userTypeId) && !(is_int($userTypeId) || ctype_digit($userTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userTypeId, true), gettype($userTypeId)), __LINE__);
        }
        $this->UserTypeId = $userTypeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
