<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommandRestrictionsResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommandRestrictionsResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class CommandRestrictionsResponse extends ApiResponse
{
    /**
     * The CommandRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfCommandRestriction
     */
    public $CommandRestrictions;
    /**
     * Constructor method for CommandRestrictionsResponse
     * @uses CommandRestrictionsResponse::setCommandRestrictions()
     * @param \Array\ArrayOfCommandRestriction $commandRestrictions
     */
    public function __construct(\Array\ArrayOfCommandRestriction $commandRestrictions = null)
    {
        $this
            ->setCommandRestrictions($commandRestrictions);
    }
    /**
     * Get CommandRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfCommandRestriction|null
     */
    public function getCommandRestrictions()
    {
        return isset($this->CommandRestrictions) ? $this->CommandRestrictions : null;
    }
    /**
     * Set CommandRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfCommandRestriction $commandRestrictions
     * @return \Struct\CommandRestrictionsResponse
     */
    public function setCommandRestrictions(\Array\ArrayOfCommandRestriction $commandRestrictions = null)
    {
        if (is_null($commandRestrictions) || (is_array($commandRestrictions) && empty($commandRestrictions))) {
            unset($this->CommandRestrictions);
        } else {
            $this->CommandRestrictions = $commandRestrictions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\CommandRestrictionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
