<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommandReason Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommandReason
 * @subpackage Structs
 * @date 2019-10-21
 */
class CommandReason extends AbstractStructBase
{
    /**
     * The CommandIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfunsignedByte
     */
    public $CommandIds;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The ShortDesc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDesc;
    /**
     * Constructor method for CommandReason
     * @uses CommandReason::setCommandIds()
     * @uses CommandReason::setDescription()
     * @uses CommandReason::setEnabled()
     * @uses CommandReason::setId()
     * @uses CommandReason::setReasonCode()
     * @uses CommandReason::setShortDesc()
     * @param \Array\ArrayOfunsignedByte $commandIds
     * @param string $description
     * @param bool $enabled
     * @param int $id
     * @param string $reasonCode
     * @param string $shortDesc
     */
    public function __construct(\Array\ArrayOfunsignedByte $commandIds = null, $description = null, $enabled = null, $id = null, $reasonCode = null, $shortDesc = null)
    {
        $this
            ->setCommandIds($commandIds)
            ->setDescription($description)
            ->setEnabled($enabled)
            ->setId($id)
            ->setReasonCode($reasonCode)
            ->setShortDesc($shortDesc);
    }
    /**
     * Get CommandIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfunsignedByte|null
     */
    public function getCommandIds()
    {
        return isset($this->CommandIds) ? $this->CommandIds : null;
    }
    /**
     * Set CommandIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfunsignedByte $commandIds
     * @return \Struct\CommandReason
     */
    public function setCommandIds(\Array\ArrayOfunsignedByte $commandIds = null)
    {
        if (is_null($commandIds) || (is_array($commandIds) && empty($commandIds))) {
            unset($this->CommandIds);
        } else {
            $this->CommandIds = $commandIds;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Struct\CommandReason
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \Struct\CommandReason
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\CommandReason
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \Struct\CommandReason
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get ShortDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDesc()
    {
        return isset($this->ShortDesc) ? $this->ShortDesc : null;
    }
    /**
     * Set ShortDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDesc
     * @return \Struct\CommandReason
     */
    public function setShortDesc($shortDesc = null)
    {
        // validation for constraint: string
        if (!is_null($shortDesc) && !is_string($shortDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDesc, true), gettype($shortDesc)), __LINE__);
        }
        if (is_null($shortDesc) || (is_array($shortDesc) && empty($shortDesc))) {
            unset($this->ShortDesc);
        } else {
            $this->ShortDesc = $shortDesc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\CommandReason
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
