<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Command Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Command
 * @subpackage Structs
 * @date 2019-10-21
 */
class Command extends AbstractStructBase
{
    /**
     * The AvailableForBalanceHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForBalanceHistory;
    /**
     * The AvailableForCancellations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForCancellations;
    /**
     * The AvailableForNotLogging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForNotLogging;
    /**
     * The AvailableForNotifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForNotifications;
    /**
     * The AvailableForPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForPrices;
    /**
     * The AvailableForReasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForReasons;
    /**
     * The AvailableForRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForRestrictions;
    /**
     * The AvailableForRewards
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForRewards;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExternalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalCode;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Command
     * @uses Command::setAvailableForBalanceHistory()
     * @uses Command::setAvailableForCancellations()
     * @uses Command::setAvailableForNotLogging()
     * @uses Command::setAvailableForNotifications()
     * @uses Command::setAvailableForPrices()
     * @uses Command::setAvailableForReasons()
     * @uses Command::setAvailableForRestrictions()
     * @uses Command::setAvailableForRewards()
     * @uses Command::setDescription()
     * @uses Command::setExternalCode()
     * @uses Command::setId()
     * @param bool $availableForBalanceHistory
     * @param bool $availableForCancellations
     * @param bool $availableForNotLogging
     * @param bool $availableForNotifications
     * @param bool $availableForPrices
     * @param bool $availableForReasons
     * @param bool $availableForRestrictions
     * @param bool $availableForRewards
     * @param string $description
     * @param string $externalCode
     * @param string $id
     */
    public function __construct($availableForBalanceHistory = null, $availableForCancellations = null, $availableForNotLogging = null, $availableForNotifications = null, $availableForPrices = null, $availableForReasons = null, $availableForRestrictions = null, $availableForRewards = null, $description = null, $externalCode = null, $id = null)
    {
        $this
            ->setAvailableForBalanceHistory($availableForBalanceHistory)
            ->setAvailableForCancellations($availableForCancellations)
            ->setAvailableForNotLogging($availableForNotLogging)
            ->setAvailableForNotifications($availableForNotifications)
            ->setAvailableForPrices($availableForPrices)
            ->setAvailableForReasons($availableForReasons)
            ->setAvailableForRestrictions($availableForRestrictions)
            ->setAvailableForRewards($availableForRewards)
            ->setDescription($description)
            ->setExternalCode($externalCode)
            ->setId($id);
    }
    /**
     * Get AvailableForBalanceHistory value
     * @return bool|null
     */
    public function getAvailableForBalanceHistory()
    {
        return $this->AvailableForBalanceHistory;
    }
    /**
     * Set AvailableForBalanceHistory value
     * @param bool $availableForBalanceHistory
     * @return \Struct\Command
     */
    public function setAvailableForBalanceHistory($availableForBalanceHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForBalanceHistory) && !is_bool($availableForBalanceHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForBalanceHistory, true), gettype($availableForBalanceHistory)), __LINE__);
        }
        $this->AvailableForBalanceHistory = $availableForBalanceHistory;
        return $this;
    }
    /**
     * Get AvailableForCancellations value
     * @return bool|null
     */
    public function getAvailableForCancellations()
    {
        return $this->AvailableForCancellations;
    }
    /**
     * Set AvailableForCancellations value
     * @param bool $availableForCancellations
     * @return \Struct\Command
     */
    public function setAvailableForCancellations($availableForCancellations = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForCancellations) && !is_bool($availableForCancellations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForCancellations, true), gettype($availableForCancellations)), __LINE__);
        }
        $this->AvailableForCancellations = $availableForCancellations;
        return $this;
    }
    /**
     * Get AvailableForNotLogging value
     * @return bool|null
     */
    public function getAvailableForNotLogging()
    {
        return $this->AvailableForNotLogging;
    }
    /**
     * Set AvailableForNotLogging value
     * @param bool $availableForNotLogging
     * @return \Struct\Command
     */
    public function setAvailableForNotLogging($availableForNotLogging = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForNotLogging) && !is_bool($availableForNotLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForNotLogging, true), gettype($availableForNotLogging)), __LINE__);
        }
        $this->AvailableForNotLogging = $availableForNotLogging;
        return $this;
    }
    /**
     * Get AvailableForNotifications value
     * @return bool|null
     */
    public function getAvailableForNotifications()
    {
        return $this->AvailableForNotifications;
    }
    /**
     * Set AvailableForNotifications value
     * @param bool $availableForNotifications
     * @return \Struct\Command
     */
    public function setAvailableForNotifications($availableForNotifications = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForNotifications) && !is_bool($availableForNotifications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForNotifications, true), gettype($availableForNotifications)), __LINE__);
        }
        $this->AvailableForNotifications = $availableForNotifications;
        return $this;
    }
    /**
     * Get AvailableForPrices value
     * @return bool|null
     */
    public function getAvailableForPrices()
    {
        return $this->AvailableForPrices;
    }
    /**
     * Set AvailableForPrices value
     * @param bool $availableForPrices
     * @return \Struct\Command
     */
    public function setAvailableForPrices($availableForPrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForPrices) && !is_bool($availableForPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForPrices, true), gettype($availableForPrices)), __LINE__);
        }
        $this->AvailableForPrices = $availableForPrices;
        return $this;
    }
    /**
     * Get AvailableForReasons value
     * @return bool|null
     */
    public function getAvailableForReasons()
    {
        return $this->AvailableForReasons;
    }
    /**
     * Set AvailableForReasons value
     * @param bool $availableForReasons
     * @return \Struct\Command
     */
    public function setAvailableForReasons($availableForReasons = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForReasons) && !is_bool($availableForReasons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForReasons, true), gettype($availableForReasons)), __LINE__);
        }
        $this->AvailableForReasons = $availableForReasons;
        return $this;
    }
    /**
     * Get AvailableForRestrictions value
     * @return bool|null
     */
    public function getAvailableForRestrictions()
    {
        return $this->AvailableForRestrictions;
    }
    /**
     * Set AvailableForRestrictions value
     * @param bool $availableForRestrictions
     * @return \Struct\Command
     */
    public function setAvailableForRestrictions($availableForRestrictions = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForRestrictions) && !is_bool($availableForRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForRestrictions, true), gettype($availableForRestrictions)), __LINE__);
        }
        $this->AvailableForRestrictions = $availableForRestrictions;
        return $this;
    }
    /**
     * Get AvailableForRewards value
     * @return bool|null
     */
    public function getAvailableForRewards()
    {
        return $this->AvailableForRewards;
    }
    /**
     * Set AvailableForRewards value
     * @param bool $availableForRewards
     * @return \Struct\Command
     */
    public function setAvailableForRewards($availableForRewards = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForRewards) && !is_bool($availableForRewards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForRewards, true), gettype($availableForRewards)), __LINE__);
        }
        $this->AvailableForRewards = $availableForRewards;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Struct\Command
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalCode()
    {
        return isset($this->ExternalCode) ? $this->ExternalCode : null;
    }
    /**
     * Set ExternalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalCode
     * @return \Struct\Command
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCode, true), gettype($externalCode)), __LINE__);
        }
        if (is_null($externalCode) || (is_array($externalCode) && empty($externalCode))) {
            unset($this->ExternalCode);
        } else {
            $this->ExternalCode = $externalCode;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Struct\Command
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\Command
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
