<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreasResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreasResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class AreasResponse extends ApiResponse
{
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfArea
     */
    public $Areas;
    /**
     * Constructor method for AreasResponse
     * @uses AreasResponse::setAreas()
     * @param \Array\ArrayOfArea $areas
     */
    public function __construct(\Array\ArrayOfArea $areas = null)
    {
        $this
            ->setAreas($areas);
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfArea|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfArea $areas
     * @return \Struct\AreasResponse
     */
    public function setAreas(\Array\ArrayOfArea $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\AreasResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
