<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Un Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Un extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnRegister
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\UnRegister $parameters
     * @return \Struct\UnRegisterResponse|bool
     */
    public function UnRegister(\Struct\UnRegister $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnRegister($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\UnRegisterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
