<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Take Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Take extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TakePoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\TakePoints $parameters
     * @return \Struct\TakePointsResponse|bool
     */
    public function TakePoints(\Struct\TakePoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TakePoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\TakePointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
