<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendEmailLink
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\SendEmailLink $parameters
     * @return \Struct\SendEmailLinkResponse|bool
     */
    public function SendEmailLink(\Struct\SendEmailLink $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendEmailLink($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\SendEmailLinkResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
