<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named QueryAvailableItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\QueryAvailableItems $parameters
     * @return \Struct\QueryAvailableItemsResponse|bool
     */
    public function QueryAvailableItems(\Struct\QueryAvailableItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryAvailableItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\QueryPoints $parameters
     * @return \Struct\QueryPointsResponse|bool
     */
    public function QueryPoints(\Struct\QueryPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryStockPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\QueryStockPoints $parameters
     * @return \Struct\QueryStockPointsResponse|bool
     */
    public function QueryStockPoints(\Struct\QueryStockPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryStockPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named QueryDefaultAvailableItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\QueryDefaultAvailableItems $parameters
     * @return \Struct\QueryDefaultAvailableItemsResponse|bool
     */
    public function QueryDefaultAvailableItems(\Struct\QueryDefaultAvailableItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->QueryDefaultAvailableItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\QueryAvailableItemsResponse|\Struct\QueryDefaultAvailableItemsResponse|\Struct\QueryPointsResponse|\Struct\QueryStockPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
