<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Disable Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Disable extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DisableCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\DisableCustomer $parameters
     * @return \Struct\DisableCustomerResponse|bool
     */
    public function DisableCustomer(\Struct\DisableCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DisableCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\DisableCustomerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
