<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Buy Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Buy extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuyPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\BuyPoints $parameters
     * @return \Struct\BuyPointsResponse|bool
     */
    public function BuyPoints(\Struct\BuyPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuyPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\BuyPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
