<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddPoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\AddPoints $parameters
     * @return \Struct\AddPointsResponse|bool
     */
    public function AddPoints(\Struct\AddPoints $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddPoints($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\AddPointsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
