<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWallet Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWallet
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfWallet extends AbstractStructArrayBase
{
    /**
     * The Wallet
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\Wallet[]
     */
    public $Wallet;
    /**
     * Constructor method for ArrayOfWallet
     * @uses ArrayOfWallet::setWallet()
     * @param \Struct\Wallet[] $wallet
     */
    public function __construct(array $wallet = array())
    {
        $this
            ->setWallet($wallet);
    }
    /**
     * Get Wallet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\Wallet[]|null
     */
    public function getWallet()
    {
        return isset($this->Wallet) ? $this->Wallet : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWallet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWallet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWalletForArrayConstraintsFromSetWallet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWalletWalletItem) {
            // validation for constraint: itemType
            if (!$arrayOfWalletWalletItem instanceof \Struct\Wallet) {
                $invalidValues[] = is_object($arrayOfWalletWalletItem) ? get_class($arrayOfWalletWalletItem) : sprintf('%s(%s)', gettype($arrayOfWalletWalletItem), var_export($arrayOfWalletWalletItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Wallet property can only contain items of type \Struct\Wallet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Wallet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\Wallet[] $wallet
     * @return \Array\ArrayOfWallet
     */
    public function setWallet(array $wallet = array())
    {
        // validation for constraint: array
        if ('' !== ($walletArrayErrorMessage = self::validateWalletForArrayConstraintsFromSetWallet($wallet))) {
            throw new \InvalidArgumentException($walletArrayErrorMessage, __LINE__);
        }
        if (is_null($wallet) || (is_array($wallet) && empty($wallet))) {
            unset($this->Wallet);
        } else {
            $this->Wallet = $wallet;
        }
        return $this;
    }
    /**
     * Add item to Wallet value
     * @throws \InvalidArgumentException
     * @param \Struct\Wallet $item
     * @return \Array\ArrayOfWallet
     */
    public function addToWallet(\Struct\Wallet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\Wallet) {
            throw new \InvalidArgumentException(sprintf('The Wallet property can only contain items of type \Struct\Wallet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Wallet[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\Wallet|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\Wallet|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\Wallet|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\Wallet|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\Wallet|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Wallet
     */
    public function getAttributeName()
    {
        return 'Wallet';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfWallet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
