<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRedeemableItemPrice Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRedeemableItemPrice
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfRedeemableItemPrice extends AbstractStructArrayBase
{
    /**
     * The RedeemableItemPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\RedeemableItemPrice[]
     */
    public $RedeemableItemPrice;
    /**
     * Constructor method for ArrayOfRedeemableItemPrice
     * @uses ArrayOfRedeemableItemPrice::setRedeemableItemPrice()
     * @param \Struct\RedeemableItemPrice[] $redeemableItemPrice
     */
    public function __construct(array $redeemableItemPrice = array())
    {
        $this
            ->setRedeemableItemPrice($redeemableItemPrice);
    }
    /**
     * Get RedeemableItemPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\RedeemableItemPrice[]|null
     */
    public function getRedeemableItemPrice()
    {
        return isset($this->RedeemableItemPrice) ? $this->RedeemableItemPrice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRedeemableItemPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedeemableItemPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedeemableItemPriceForArrayConstraintsFromSetRedeemableItemPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRedeemableItemPriceRedeemableItemPriceItem) {
            // validation for constraint: itemType
            if (!$arrayOfRedeemableItemPriceRedeemableItemPriceItem instanceof \Struct\RedeemableItemPrice) {
                $invalidValues[] = is_object($arrayOfRedeemableItemPriceRedeemableItemPriceItem) ? get_class($arrayOfRedeemableItemPriceRedeemableItemPriceItem) : sprintf('%s(%s)', gettype($arrayOfRedeemableItemPriceRedeemableItemPriceItem), var_export($arrayOfRedeemableItemPriceRedeemableItemPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedeemableItemPrice property can only contain items of type \Struct\RedeemableItemPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedeemableItemPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\RedeemableItemPrice[] $redeemableItemPrice
     * @return \Array\ArrayOfRedeemableItemPrice
     */
    public function setRedeemableItemPrice(array $redeemableItemPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($redeemableItemPriceArrayErrorMessage = self::validateRedeemableItemPriceForArrayConstraintsFromSetRedeemableItemPrice($redeemableItemPrice))) {
            throw new \InvalidArgumentException($redeemableItemPriceArrayErrorMessage, __LINE__);
        }
        if (is_null($redeemableItemPrice) || (is_array($redeemableItemPrice) && empty($redeemableItemPrice))) {
            unset($this->RedeemableItemPrice);
        } else {
            $this->RedeemableItemPrice = $redeemableItemPrice;
        }
        return $this;
    }
    /**
     * Add item to RedeemableItemPrice value
     * @throws \InvalidArgumentException
     * @param \Struct\RedeemableItemPrice $item
     * @return \Array\ArrayOfRedeemableItemPrice
     */
    public function addToRedeemableItemPrice(\Struct\RedeemableItemPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\RedeemableItemPrice) {
            throw new \InvalidArgumentException(sprintf('The RedeemableItemPrice property can only contain items of type \Struct\RedeemableItemPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedeemableItemPrice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\RedeemableItemPrice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\RedeemableItemPrice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\RedeemableItemPrice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\RedeemableItemPrice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\RedeemableItemPrice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RedeemableItemPrice
     */
    public function getAttributeName()
    {
        return 'RedeemableItemPrice';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfRedeemableItemPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
