<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRedeemableItem Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRedeemableItem
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfRedeemableItem extends AbstractStructArrayBase
{
    /**
     * The RedeemableItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\RedeemableItem[]
     */
    public $RedeemableItem;
    /**
     * Constructor method for ArrayOfRedeemableItem
     * @uses ArrayOfRedeemableItem::setRedeemableItem()
     * @param \Struct\RedeemableItem[] $redeemableItem
     */
    public function __construct(array $redeemableItem = array())
    {
        $this
            ->setRedeemableItem($redeemableItem);
    }
    /**
     * Get RedeemableItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\RedeemableItem[]|null
     */
    public function getRedeemableItem()
    {
        return isset($this->RedeemableItem) ? $this->RedeemableItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRedeemableItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedeemableItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedeemableItemForArrayConstraintsFromSetRedeemableItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRedeemableItemRedeemableItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRedeemableItemRedeemableItemItem instanceof \Struct\RedeemableItem) {
                $invalidValues[] = is_object($arrayOfRedeemableItemRedeemableItemItem) ? get_class($arrayOfRedeemableItemRedeemableItemItem) : sprintf('%s(%s)', gettype($arrayOfRedeemableItemRedeemableItemItem), var_export($arrayOfRedeemableItemRedeemableItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedeemableItem property can only contain items of type \Struct\RedeemableItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedeemableItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\RedeemableItem[] $redeemableItem
     * @return \Array\ArrayOfRedeemableItem
     */
    public function setRedeemableItem(array $redeemableItem = array())
    {
        // validation for constraint: array
        if ('' !== ($redeemableItemArrayErrorMessage = self::validateRedeemableItemForArrayConstraintsFromSetRedeemableItem($redeemableItem))) {
            throw new \InvalidArgumentException($redeemableItemArrayErrorMessage, __LINE__);
        }
        if (is_null($redeemableItem) || (is_array($redeemableItem) && empty($redeemableItem))) {
            unset($this->RedeemableItem);
        } else {
            $this->RedeemableItem = $redeemableItem;
        }
        return $this;
    }
    /**
     * Add item to RedeemableItem value
     * @throws \InvalidArgumentException
     * @param \Struct\RedeemableItem $item
     * @return \Array\ArrayOfRedeemableItem
     */
    public function addToRedeemableItem(\Struct\RedeemableItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\RedeemableItem) {
            throw new \InvalidArgumentException(sprintf('The RedeemableItem property can only contain items of type \Struct\RedeemableItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedeemableItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\RedeemableItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\RedeemableItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\RedeemableItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\RedeemableItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\RedeemableItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RedeemableItem
     */
    public function getAttributeName()
    {
        return 'RedeemableItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfRedeemableItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
