<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArea Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfArea
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfArea extends AbstractStructArrayBase
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\Area[]
     */
    public $Area;
    /**
     * Constructor method for ArrayOfArea
     * @uses ArrayOfArea::setArea()
     * @param \Struct\Area[] $area
     */
    public function __construct(array $area = array())
    {
        $this
            ->setArea($area);
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\Area[]|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * This method is responsible for validating the values passed to the setArea method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArea method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAreaForArrayConstraintsFromSetArea(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAreaAreaItem) {
            // validation for constraint: itemType
            if (!$arrayOfAreaAreaItem instanceof \Struct\Area) {
                $invalidValues[] = is_object($arrayOfAreaAreaItem) ? get_class($arrayOfAreaAreaItem) : sprintf('%s(%s)', gettype($arrayOfAreaAreaItem), var_export($arrayOfAreaAreaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Area property can only contain items of type \Struct\Area, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\Area[] $area
     * @return \Array\ArrayOfArea
     */
    public function setArea(array $area = array())
    {
        // validation for constraint: array
        if ('' !== ($areaArrayErrorMessage = self::validateAreaForArrayConstraintsFromSetArea($area))) {
            throw new \InvalidArgumentException($areaArrayErrorMessage, __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \Struct\Area $item
     * @return \Array\ArrayOfArea
     */
    public function addToArea(\Struct\Area $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\Area) {
            throw new \InvalidArgumentException(sprintf('The Area property can only contain items of type \Struct\Area, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\Area|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\Area|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\Area|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\Area|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\Area|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Area
     */
    public function getAttributeName()
    {
        return 'Area';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
