<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrderItem Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchaseOrderItem
 * @subpackage Structs
 * @date 2019-10-21
 */
class PurchaseOrderItem extends AbstractStructBase
{
    /**
     * The DeliveryChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\DeliveryChannel
     */
    public $DeliveryChannel;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The RedeemableItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedeemableItemId;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\WalletType
     */
    public $WalletType;
    /**
     * Constructor method for PurchaseOrderItem
     * @uses PurchaseOrderItem::setDeliveryChannel()
     * @uses PurchaseOrderItem::setQuantity()
     * @uses PurchaseOrderItem::setRedeemableItemId()
     * @uses PurchaseOrderItem::setWalletType()
     * @param \Struct\DeliveryChannel $deliveryChannel
     * @param int $quantity
     * @param int $redeemableItemId
     * @param \Struct\WalletType $walletType
     */
    public function __construct(\Struct\DeliveryChannel $deliveryChannel = null, $quantity = null, $redeemableItemId = null, \Struct\WalletType $walletType = null)
    {
        $this
            ->setDeliveryChannel($deliveryChannel)
            ->setQuantity($quantity)
            ->setRedeemableItemId($redeemableItemId)
            ->setWalletType($walletType);
    }
    /**
     * Get DeliveryChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\DeliveryChannel|null
     */
    public function getDeliveryChannel()
    {
        return isset($this->DeliveryChannel) ? $this->DeliveryChannel : null;
    }
    /**
     * Set DeliveryChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\DeliveryChannel $deliveryChannel
     * @return \Struct\PurchaseOrderItem
     */
    public function setDeliveryChannel(\Struct\DeliveryChannel $deliveryChannel = null)
    {
        if (is_null($deliveryChannel) || (is_array($deliveryChannel) && empty($deliveryChannel))) {
            unset($this->DeliveryChannel);
        } else {
            $this->DeliveryChannel = $deliveryChannel;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Struct\PurchaseOrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RedeemableItemId value
     * @return int|null
     */
    public function getRedeemableItemId()
    {
        return $this->RedeemableItemId;
    }
    /**
     * Set RedeemableItemId value
     * @param int $redeemableItemId
     * @return \Struct\PurchaseOrderItem
     */
    public function setRedeemableItemId($redeemableItemId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemId) && !(is_int($redeemableItemId) || ctype_digit($redeemableItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemId, true), gettype($redeemableItemId)), __LINE__);
        }
        $this->RedeemableItemId = $redeemableItemId;
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\WalletType|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\WalletType $walletType
     * @return \Struct\PurchaseOrderItem
     */
    public function setWalletType(\Struct\WalletType $walletType = null)
    {
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\PurchaseOrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
