<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsCustomerRegisteredResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IsCustomerRegisteredResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class IsCustomerRegisteredResponse extends ApiResponse
{
    /**
     * The IsCustomerRegisteredResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\IsCustomerRegisteredResponse
     */
    public $IsCustomerRegisteredResult;
    /**
     * The IsCustomerRegistered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCustomerRegistered;
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEnabled;
    /**
     * The RegistrationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationDate;
    /**
     * Constructor method for IsCustomerRegisteredResponse
     * @uses IsCustomerRegisteredResponse::setIsCustomerRegisteredResult()
     * @uses IsCustomerRegisteredResponse::setIsCustomerRegistered()
     * @uses IsCustomerRegisteredResponse::setIsEnabled()
     * @uses IsCustomerRegisteredResponse::setRegistrationDate()
     * @param \Struct\IsCustomerRegisteredResponse $isCustomerRegisteredResult
     * @param bool $isCustomerRegistered
     * @param bool $isEnabled
     * @param string $registrationDate
     */
    public function __construct(\Struct\IsCustomerRegisteredResponse $isCustomerRegisteredResult = null, $isCustomerRegistered = null, $isEnabled = null, $registrationDate = null)
    {
        $this
            ->setIsCustomerRegisteredResult($isCustomerRegisteredResult)
            ->setIsCustomerRegistered($isCustomerRegistered)
            ->setIsEnabled($isEnabled)
            ->setRegistrationDate($registrationDate);
    }
    /**
     * Get IsCustomerRegisteredResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\IsCustomerRegisteredResponse|null
     */
    public function getIsCustomerRegisteredResult()
    {
        return isset($this->IsCustomerRegisteredResult) ? $this->IsCustomerRegisteredResult : null;
    }
    /**
     * Set IsCustomerRegisteredResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\IsCustomerRegisteredResponse $isCustomerRegisteredResult
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public function setIsCustomerRegisteredResult(\Struct\IsCustomerRegisteredResponse $isCustomerRegisteredResult = null)
    {
        if (is_null($isCustomerRegisteredResult) || (is_array($isCustomerRegisteredResult) && empty($isCustomerRegisteredResult))) {
            unset($this->IsCustomerRegisteredResult);
        } else {
            $this->IsCustomerRegisteredResult = $isCustomerRegisteredResult;
        }
        return $this;
    }
    /**
     * Get IsCustomerRegistered value
     * @return bool|null
     */
    public function getIsCustomerRegistered()
    {
        return $this->IsCustomerRegistered;
    }
    /**
     * Set IsCustomerRegistered value
     * @param bool $isCustomerRegistered
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public function setIsCustomerRegistered($isCustomerRegistered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomerRegistered) && !is_bool($isCustomerRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCustomerRegistered, true), gettype($isCustomerRegistered)), __LINE__);
        }
        $this->IsCustomerRegistered = $isCustomerRegistered;
        return $this;
    }
    /**
     * Get IsEnabled value
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return $this->IsEnabled;
    }
    /**
     * Set IsEnabled value
     * @param bool $isEnabled
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        $this->IsEnabled = $isEnabled;
        return $this;
    }
    /**
     * Get RegistrationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return isset($this->RegistrationDate) ? $this->RegistrationDate : null;
    }
    /**
     * Set RegistrationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationDate
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        if (is_null($registrationDate) || (is_array($registrationDate) && empty($registrationDate))) {
            unset($this->RegistrationDate);
        } else {
            $this->RegistrationDate = $registrationDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
