<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApiResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApiResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class ApiResponse extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\Error
     */
    public $Error;
    /**
     * The ExternalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExternalReferenceId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for ApiResponse
     * @uses ApiResponse::setError()
     * @uses ApiResponse::setExternalReferenceId()
     * @uses ApiResponse::setStatus()
     * @param \Struct\Error $error
     * @param int $externalReferenceId
     * @param string $status
     */
    public function __construct(\Struct\Error $error = null, $externalReferenceId = null, $status = null)
    {
        $this
            ->setError($error)
            ->setExternalReferenceId($externalReferenceId)
            ->setStatus($status);
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\Error|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\Error $error
     * @return \Struct\ApiResponse
     */
    public function setError(\Struct\Error $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get ExternalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->ExternalReferenceId;
    }
    /**
     * Set ExternalReferenceId value
     * @param int $externalReferenceId
     * @return \Struct\ApiResponse
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->ExternalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \Enum\ApiResponseStatus::valueIsValid()
     * @uses \Enum\ApiResponseStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \Struct\ApiResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\Enum\ApiResponseStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Enum\ApiResponseStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \Enum\ApiResponseStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\ApiResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
