<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Redemption Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Redemption extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RedemptionHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\RedemptionHistory $parameters
     * @return \Struct\RedemptionHistoryResponse|bool
     */
    public function RedemptionHistory(\Struct\RedemptionHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RedemptionHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\RedemptionHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
