<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IsCustomerRegistered
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\IsCustomerRegistered $parameters
     * @return \Struct\IsCustomerRegisteredResponse|bool
     */
    public function IsCustomerRegistered(\Struct\IsCustomerRegistered $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IsCustomerRegistered($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\IsCustomerRegisteredResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
