<?php

namespace Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel Service
 * @subpackage Services
 * @date 2019-10-21
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelRedeem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Struct\CancelRedeem $parameters
     * @return \Struct\CancelRedeemResponse|bool
     */
    public function CancelRedeem(\Struct\CancelRedeem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelRedeem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Struct\CancelRedeemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
