<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStock Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStock
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfStock extends AbstractStructArrayBase
{
    /**
     * The Stock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\Stock[]
     */
    public $Stock;
    /**
     * Constructor method for ArrayOfStock
     * @uses ArrayOfStock::setStock()
     * @param \Struct\Stock[] $stock
     */
    public function __construct(array $stock = array())
    {
        $this
            ->setStock($stock);
    }
    /**
     * Get Stock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\Stock[]|null
     */
    public function getStock()
    {
        return isset($this->Stock) ? $this->Stock : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStockForArrayConstraintsFromSetStock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStockStockItem) {
            // validation for constraint: itemType
            if (!$arrayOfStockStockItem instanceof \Struct\Stock) {
                $invalidValues[] = is_object($arrayOfStockStockItem) ? get_class($arrayOfStockStockItem) : sprintf('%s(%s)', gettype($arrayOfStockStockItem), var_export($arrayOfStockStockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stock property can only contain items of type \Struct\Stock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\Stock[] $stock
     * @return \Array\ArrayOfStock
     */
    public function setStock(array $stock = array())
    {
        // validation for constraint: array
        if ('' !== ($stockArrayErrorMessage = self::validateStockForArrayConstraintsFromSetStock($stock))) {
            throw new \InvalidArgumentException($stockArrayErrorMessage, __LINE__);
        }
        if (is_null($stock) || (is_array($stock) && empty($stock))) {
            unset($this->Stock);
        } else {
            $this->Stock = $stock;
        }
        return $this;
    }
    /**
     * Add item to Stock value
     * @throws \InvalidArgumentException
     * @param \Struct\Stock $item
     * @return \Array\ArrayOfStock
     */
    public function addToStock(\Struct\Stock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\Stock) {
            throw new \InvalidArgumentException(sprintf('The Stock property can only contain items of type \Struct\Stock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stock[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\Stock|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\Stock|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\Stock|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\Stock|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\Stock|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Stock
     */
    public function getAttributeName()
    {
        return 'Stock';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfStock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
