<?php

namespace Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPurchaseOrderItemInfo Array
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPurchaseOrderItemInfo
 * @subpackage Arrays
 * @date 2019-10-21
 */
class ArrayOfPurchaseOrderItemInfo extends AbstractStructArrayBase
{
    /**
     * The PurchaseOrderItemInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\PurchaseOrderItemInfo[]
     */
    public $PurchaseOrderItemInfo;
    /**
     * Constructor method for ArrayOfPurchaseOrderItemInfo
     * @uses ArrayOfPurchaseOrderItemInfo::setPurchaseOrderItemInfo()
     * @param \Struct\PurchaseOrderItemInfo[] $purchaseOrderItemInfo
     */
    public function __construct(array $purchaseOrderItemInfo = array())
    {
        $this
            ->setPurchaseOrderItemInfo($purchaseOrderItemInfo);
    }
    /**
     * Get PurchaseOrderItemInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\PurchaseOrderItemInfo[]|null
     */
    public function getPurchaseOrderItemInfo()
    {
        return isset($this->PurchaseOrderItemInfo) ? $this->PurchaseOrderItemInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseOrderItemInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseOrderItemInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseOrderItemInfoForArrayConstraintsFromSetPurchaseOrderItemInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem instanceof \Struct\PurchaseOrderItemInfo) {
                $invalidValues[] = is_object($arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem) ? get_class($arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem) : sprintf('%s(%s)', gettype($arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem), var_export($arrayOfPurchaseOrderItemInfoPurchaseOrderItemInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PurchaseOrderItemInfo property can only contain items of type \Struct\PurchaseOrderItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PurchaseOrderItemInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Struct\PurchaseOrderItemInfo[] $purchaseOrderItemInfo
     * @return \Array\ArrayOfPurchaseOrderItemInfo
     */
    public function setPurchaseOrderItemInfo(array $purchaseOrderItemInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseOrderItemInfoArrayErrorMessage = self::validatePurchaseOrderItemInfoForArrayConstraintsFromSetPurchaseOrderItemInfo($purchaseOrderItemInfo))) {
            throw new \InvalidArgumentException($purchaseOrderItemInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($purchaseOrderItemInfo) || (is_array($purchaseOrderItemInfo) && empty($purchaseOrderItemInfo))) {
            unset($this->PurchaseOrderItemInfo);
        } else {
            $this->PurchaseOrderItemInfo = $purchaseOrderItemInfo;
        }
        return $this;
    }
    /**
     * Add item to PurchaseOrderItemInfo value
     * @throws \InvalidArgumentException
     * @param \Struct\PurchaseOrderItemInfo $item
     * @return \Array\ArrayOfPurchaseOrderItemInfo
     */
    public function addToPurchaseOrderItemInfo(\Struct\PurchaseOrderItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Struct\PurchaseOrderItemInfo) {
            throw new \InvalidArgumentException(sprintf('The PurchaseOrderItemInfo property can only contain items of type \Struct\PurchaseOrderItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PurchaseOrderItemInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Struct\PurchaseOrderItemInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Struct\PurchaseOrderItemInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Struct\PurchaseOrderItemInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Struct\PurchaseOrderItemInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Struct\PurchaseOrderItemInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PurchaseOrderItemInfo
     */
    public function getAttributeName()
    {
        return 'PurchaseOrderItemInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Array\ArrayOfPurchaseOrderItemInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
