<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletType Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WalletType
 * @subpackage Structs
 * @date 2019-10-21
 */
class WalletType extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExternalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalCode;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsDisabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDisabled;
    /**
     * The IsReadOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReadOnly;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortDescription;
    /**
     * Constructor method for WalletType
     * @uses WalletType::setDescription()
     * @uses WalletType::setExternalCode()
     * @uses WalletType::setId()
     * @uses WalletType::setIsDisabled()
     * @uses WalletType::setIsReadOnly()
     * @uses WalletType::setShortDescription()
     * @param string $description
     * @param string $externalCode
     * @param int $id
     * @param bool $isDisabled
     * @param bool $isReadOnly
     * @param string $shortDescription
     */
    public function __construct($description = null, $externalCode = null, $id = null, $isDisabled = null, $isReadOnly = null, $shortDescription = null)
    {
        $this
            ->setDescription($description)
            ->setExternalCode($externalCode)
            ->setId($id)
            ->setIsDisabled($isDisabled)
            ->setIsReadOnly($isReadOnly)
            ->setShortDescription($shortDescription);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Struct\WalletType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalCode()
    {
        return isset($this->ExternalCode) ? $this->ExternalCode : null;
    }
    /**
     * Set ExternalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalCode
     * @return \Struct\WalletType
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCode, true), gettype($externalCode)), __LINE__);
        }
        if (is_null($externalCode) || (is_array($externalCode) && empty($externalCode))) {
            unset($this->ExternalCode);
        } else {
            $this->ExternalCode = $externalCode;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Struct\WalletType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsDisabled value
     * @return bool|null
     */
    public function getIsDisabled()
    {
        return $this->IsDisabled;
    }
    /**
     * Set IsDisabled value
     * @param bool $isDisabled
     * @return \Struct\WalletType
     */
    public function setIsDisabled($isDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDisabled) && !is_bool($isDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisabled, true), gettype($isDisabled)), __LINE__);
        }
        $this->IsDisabled = $isDisabled;
        return $this;
    }
    /**
     * Get IsReadOnly value
     * @return bool|null
     */
    public function getIsReadOnly()
    {
        return $this->IsReadOnly;
    }
    /**
     * Set IsReadOnly value
     * @param bool $isReadOnly
     * @return \Struct\WalletType
     */
    public function setIsReadOnly($isReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadOnly, true), gettype($isReadOnly)), __LINE__);
        }
        $this->IsReadOnly = $isReadOnly;
        return $this;
    }
    /**
     * Get ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortDescription()
    {
        return isset($this->ShortDescription) ? $this->ShortDescription : null;
    }
    /**
     * Set ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortDescription
     * @return \Struct\WalletType
     */
    public function setShortDescription($shortDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shortDescription) && !is_string($shortDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortDescription, true), gettype($shortDescription)), __LINE__);
        }
        if (is_null($shortDescription) || (is_array($shortDescription) && empty($shortDescription))) {
            unset($this->ShortDescription);
        } else {
            $this->ShortDescription = $shortDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\WalletType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
