<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemovePointsResponse Struct
 * @subpackage Structs
 * @date 2019-10-21
 */
class RemovePointsResponse extends AbstractStructBase
{
    /**
     * The RemovePointsResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Struct\ApiResponse
     */
    public $RemovePointsResult;
    /**
     * Constructor method for RemovePointsResponse
     * @uses RemovePointsResponse::setRemovePointsResult()
     * @param \Struct\ApiResponse $removePointsResult
     */
    public function __construct(\Struct\ApiResponse $removePointsResult = null)
    {
        $this
            ->setRemovePointsResult($removePointsResult);
    }
    /**
     * Get RemovePointsResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Struct\ApiResponse|null
     */
    public function getRemovePointsResult()
    {
        return isset($this->RemovePointsResult) ? $this->RemovePointsResult : null;
    }
    /**
     * Set RemovePointsResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Struct\ApiResponse $removePointsResult
     * @return \Struct\RemovePointsResponse
     */
    public function setRemovePointsResult(\Struct\ApiResponse $removePointsResult = null)
    {
        if (is_null($removePointsResult) || (is_array($removePointsResult) && empty($removePointsResult))) {
            unset($this->RemovePointsResult);
        } else {
            $this->RemovePointsResult = $removePointsResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RemovePointsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
