<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedemptionResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedemptionResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedemptionResponse extends ApiResponse
{
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderId;
    /**
     * The PurchaseOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfPurchaseOrderItemInfo
     */
    public $PurchaseOrder;
    /**
     * Constructor method for RedemptionResponse
     * @uses RedemptionResponse::setOrderId()
     * @uses RedemptionResponse::setPurchaseOrder()
     * @param int $orderId
     * @param \Array\ArrayOfPurchaseOrderItemInfo $purchaseOrder
     */
    public function __construct($orderId = null, \Array\ArrayOfPurchaseOrderItemInfo $purchaseOrder = null)
    {
        $this
            ->setOrderId($orderId)
            ->setPurchaseOrder($purchaseOrder);
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderId
     * @return \Struct\RedemptionResponse
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get PurchaseOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfPurchaseOrderItemInfo|null
     */
    public function getPurchaseOrder()
    {
        return isset($this->PurchaseOrder) ? $this->PurchaseOrder : null;
    }
    /**
     * Set PurchaseOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfPurchaseOrderItemInfo $purchaseOrder
     * @return \Struct\RedemptionResponse
     */
    public function setPurchaseOrder(\Array\ArrayOfPurchaseOrderItemInfo $purchaseOrder = null)
    {
        if (is_null($purchaseOrder) || (is_array($purchaseOrder) && empty($purchaseOrder))) {
            unset($this->PurchaseOrder);
        } else {
            $this->PurchaseOrder = $purchaseOrder;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedemptionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
