<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemableItemDetails Struct
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedeemableItemDetails extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The externalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $externalReferenceId;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $language;
    /**
     * The redeemableItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOflong
     */
    public $redeemableItemIds;
    /**
     * Constructor method for RedeemableItemDetails
     * @uses RedeemableItemDetails::setSource()
     * @uses RedeemableItemDetails::setChannel()
     * @uses RedeemableItemDetails::setExternalReferenceId()
     * @uses RedeemableItemDetails::setLanguage()
     * @uses RedeemableItemDetails::setRedeemableItemIds()
     * @param string $source
     * @param string $channel
     * @param int $externalReferenceId
     * @param string $language
     * @param \Array\ArrayOflong $redeemableItemIds
     */
    public function __construct($source = null, $channel = null, $externalReferenceId = null, $language = null, \Array\ArrayOflong $redeemableItemIds = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setExternalReferenceId($externalReferenceId)
            ->setLanguage($language)
            ->setRedeemableItemIds($redeemableItemIds);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \Struct\RedeemableItemDetails
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \Struct\RedeemableItemDetails
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get externalReferenceId value
     * @return int|null
     */
    public function getExternalReferenceId()
    {
        return $this->externalReferenceId;
    }
    /**
     * Set externalReferenceId value
     * @param int $externalReferenceId
     * @return \Struct\RedeemableItemDetails
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: int
        if (!is_null($externalReferenceId) && !(is_int($externalReferenceId) || ctype_digit($externalReferenceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        $this->externalReferenceId = $externalReferenceId;
        return $this;
    }
    /**
     * Get language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->language) ? $this->language : null;
    }
    /**
     * Set language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \Struct\RedeemableItemDetails
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->language);
        } else {
            $this->language = $language;
        }
        return $this;
    }
    /**
     * Get redeemableItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOflong|null
     */
    public function getRedeemableItemIds()
    {
        return isset($this->redeemableItemIds) ? $this->redeemableItemIds : null;
    }
    /**
     * Set redeemableItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOflong $redeemableItemIds
     * @return \Struct\RedeemableItemDetails
     */
    public function setRedeemableItemIds(\Array\ArrayOflong $redeemableItemIds = null)
    {
        if (is_null($redeemableItemIds) || (is_array($redeemableItemIds) && empty($redeemableItemIds))) {
            unset($this->redeemableItemIds);
        } else {
            $this->redeemableItemIds = $redeemableItemIds;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedeemableItemDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
