<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RedeemItemCancel Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RedeemItemCancel
 * @subpackage Structs
 * @date 2019-10-21
 */
class RedeemItemCancel extends AbstractStructBase
{
    /**
     * The CancelationReasonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CancelationReasonId;
    /**
     * The OverwriteDefaultRefundPointsPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OverwriteDefaultRefundPointsPercent;
    /**
     * The RedemptionItemLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedemptionItemLogId;
    /**
     * The RefundPointsPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RefundPointsPercent;
    /**
     * The WalletType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WalletType;
    /**
     * Constructor method for RedeemItemCancel
     * @uses RedeemItemCancel::setCancelationReasonId()
     * @uses RedeemItemCancel::setOverwriteDefaultRefundPointsPercent()
     * @uses RedeemItemCancel::setRedemptionItemLogId()
     * @uses RedeemItemCancel::setRefundPointsPercent()
     * @uses RedeemItemCancel::setWalletType()
     * @param int $cancelationReasonId
     * @param int $overwriteDefaultRefundPointsPercent
     * @param int $redemptionItemLogId
     * @param int $refundPointsPercent
     * @param string $walletType
     */
    public function __construct($cancelationReasonId = null, $overwriteDefaultRefundPointsPercent = null, $redemptionItemLogId = null, $refundPointsPercent = null, $walletType = null)
    {
        $this
            ->setCancelationReasonId($cancelationReasonId)
            ->setOverwriteDefaultRefundPointsPercent($overwriteDefaultRefundPointsPercent)
            ->setRedemptionItemLogId($redemptionItemLogId)
            ->setRefundPointsPercent($refundPointsPercent)
            ->setWalletType($walletType);
    }
    /**
     * Get CancelationReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCancelationReasonId()
    {
        return isset($this->CancelationReasonId) ? $this->CancelationReasonId : null;
    }
    /**
     * Set CancelationReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cancelationReasonId
     * @return \Struct\RedeemItemCancel
     */
    public function setCancelationReasonId($cancelationReasonId = null)
    {
        // validation for constraint: int
        if (!is_null($cancelationReasonId) && !(is_int($cancelationReasonId) || ctype_digit($cancelationReasonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancelationReasonId, true), gettype($cancelationReasonId)), __LINE__);
        }
        if (is_null($cancelationReasonId) || (is_array($cancelationReasonId) && empty($cancelationReasonId))) {
            unset($this->CancelationReasonId);
        } else {
            $this->CancelationReasonId = $cancelationReasonId;
        }
        return $this;
    }
    /**
     * Get OverwriteDefaultRefundPointsPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOverwriteDefaultRefundPointsPercent()
    {
        return isset($this->OverwriteDefaultRefundPointsPercent) ? $this->OverwriteDefaultRefundPointsPercent : null;
    }
    /**
     * Set OverwriteDefaultRefundPointsPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $overwriteDefaultRefundPointsPercent
     * @return \Struct\RedeemItemCancel
     */
    public function setOverwriteDefaultRefundPointsPercent($overwriteDefaultRefundPointsPercent = null)
    {
        // validation for constraint: int
        if (!is_null($overwriteDefaultRefundPointsPercent) && !(is_int($overwriteDefaultRefundPointsPercent) || ctype_digit($overwriteDefaultRefundPointsPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($overwriteDefaultRefundPointsPercent, true), gettype($overwriteDefaultRefundPointsPercent)), __LINE__);
        }
        if (is_null($overwriteDefaultRefundPointsPercent) || (is_array($overwriteDefaultRefundPointsPercent) && empty($overwriteDefaultRefundPointsPercent))) {
            unset($this->OverwriteDefaultRefundPointsPercent);
        } else {
            $this->OverwriteDefaultRefundPointsPercent = $overwriteDefaultRefundPointsPercent;
        }
        return $this;
    }
    /**
     * Get RedemptionItemLogId value
     * @return int|null
     */
    public function getRedemptionItemLogId()
    {
        return $this->RedemptionItemLogId;
    }
    /**
     * Set RedemptionItemLogId value
     * @param int $redemptionItemLogId
     * @return \Struct\RedeemItemCancel
     */
    public function setRedemptionItemLogId($redemptionItemLogId = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionItemLogId) && !(is_int($redemptionItemLogId) || ctype_digit($redemptionItemLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionItemLogId, true), gettype($redemptionItemLogId)), __LINE__);
        }
        $this->RedemptionItemLogId = $redemptionItemLogId;
        return $this;
    }
    /**
     * Get RefundPointsPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRefundPointsPercent()
    {
        return isset($this->RefundPointsPercent) ? $this->RefundPointsPercent : null;
    }
    /**
     * Set RefundPointsPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $refundPointsPercent
     * @return \Struct\RedeemItemCancel
     */
    public function setRefundPointsPercent($refundPointsPercent = null)
    {
        // validation for constraint: int
        if (!is_null($refundPointsPercent) && !(is_int($refundPointsPercent) || ctype_digit($refundPointsPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refundPointsPercent, true), gettype($refundPointsPercent)), __LINE__);
        }
        if (is_null($refundPointsPercent) || (is_array($refundPointsPercent) && empty($refundPointsPercent))) {
            unset($this->RefundPointsPercent);
        } else {
            $this->RefundPointsPercent = $refundPointsPercent;
        }
        return $this;
    }
    /**
     * Get WalletType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWalletType()
    {
        return isset($this->WalletType) ? $this->WalletType : null;
    }
    /**
     * Set WalletType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $walletType
     * @return \Struct\RedeemItemCancel
     */
    public function setWalletType($walletType = null)
    {
        // validation for constraint: string
        if (!is_null($walletType) && !is_string($walletType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletType, true), gettype($walletType)), __LINE__);
        }
        if (is_null($walletType) || (is_array($walletType) && empty($walletType))) {
            unset($this->WalletType);
        } else {
            $this->WalletType = $walletType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\RedeemItemCancel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
