<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemQuantity Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemQuantity
 * @subpackage Structs
 * @date 2019-10-21
 */
class ItemQuantity extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The RedeemableItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedeemableItemId;
    /**
     * Constructor method for ItemQuantity
     * @uses ItemQuantity::setQuantity()
     * @uses ItemQuantity::setRedeemableItemId()
     * @param int $quantity
     * @param int $redeemableItemId
     */
    public function __construct($quantity = null, $redeemableItemId = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRedeemableItemId($redeemableItemId);
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Struct\ItemQuantity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RedeemableItemId value
     * @return int|null
     */
    public function getRedeemableItemId()
    {
        return $this->RedeemableItemId;
    }
    /**
     * Set RedeemableItemId value
     * @param int $redeemableItemId
     * @return \Struct\ItemQuantity
     */
    public function setRedeemableItemId($redeemableItemId = null)
    {
        // validation for constraint: int
        if (!is_null($redeemableItemId) && !(is_int($redeemableItemId) || ctype_digit($redeemableItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redeemableItemId, true), gettype($redeemableItemId)), __LINE__);
        }
        $this->RedeemableItemId = $redeemableItemId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\ItemQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
