<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableQuantity Struct
 * @subpackage Structs
 * @date 2019-10-21
 */
class GetAvailableQuantity extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $source;
    /**
     * The channel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $channel;
    /**
     * The items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOflong
     */
    public $items;
    /**
     * Constructor method for GetAvailableQuantity
     * @uses GetAvailableQuantity::setSource()
     * @uses GetAvailableQuantity::setChannel()
     * @uses GetAvailableQuantity::setItems()
     * @param string $source
     * @param string $channel
     * @param \Array\ArrayOflong $items
     */
    public function __construct($source = null, $channel = null, \Array\ArrayOflong $items = null)
    {
        $this
            ->setSource($source)
            ->setChannel($channel)
            ->setItems($items);
    }
    /**
     * Get source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->source) ? $this->source : null;
    }
    /**
     * Set source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \Struct\GetAvailableQuantity
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->source);
        } else {
            $this->source = $source;
        }
        return $this;
    }
    /**
     * Get channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : null;
    }
    /**
     * Set channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \Struct\GetAvailableQuantity
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->channel);
        } else {
            $this->channel = $channel;
        }
        return $this;
    }
    /**
     * Get items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOflong|null
     */
    public function getItems()
    {
        return isset($this->items) ? $this->items : null;
    }
    /**
     * Set items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOflong $items
     * @return \Struct\GetAvailableQuantity
     */
    public function setItems(\Array\ArrayOflong $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->items);
        } else {
            $this->items = $items;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\GetAvailableQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
