<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustWithRegInfo Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustWithRegInfo
 * @subpackage Structs
 * @date 2019-10-21
 */
class CustWithRegInfo extends Customer
{
    /**
     * The IsRegistered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRegistered;
    /**
     * Constructor method for CustWithRegInfo
     * @uses CustWithRegInfo::setIsRegistered()
     * @param bool $isRegistered
     */
    public function __construct($isRegistered = null)
    {
        $this
            ->setIsRegistered($isRegistered);
    }
    /**
     * Get IsRegistered value
     * @return bool|null
     */
    public function getIsRegistered()
    {
        return $this->IsRegistered;
    }
    /**
     * Set IsRegistered value
     * @param bool $isRegistered
     * @return \Struct\CustWithRegInfo
     */
    public function setIsRegistered($isRegistered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRegistered) && !is_bool($isRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRegistered, true), gettype($isRegistered)), __LINE__);
        }
        $this->IsRegistered = $isRegistered;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\CustWithRegInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
