<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelRedeemRequest Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelRedeemRequest
 * @subpackage Structs
 * @date 2019-10-21
 */
class CancelRedeemRequest extends AbstractStructBase
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfRedeemItemCancel
     */
    public $Items;
    /**
     * The RedemptionLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RedemptionLogId;
    /**
     * Constructor method for CancelRedeemRequest
     * @uses CancelRedeemRequest::setItems()
     * @uses CancelRedeemRequest::setRedemptionLogId()
     * @param \Array\ArrayOfRedeemItemCancel $items
     * @param int $redemptionLogId
     */
    public function __construct(\Array\ArrayOfRedeemItemCancel $items = null, $redemptionLogId = null)
    {
        $this
            ->setItems($items)
            ->setRedemptionLogId($redemptionLogId);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfRedeemItemCancel|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfRedeemItemCancel $items
     * @return \Struct\CancelRedeemRequest
     */
    public function setItems(\Array\ArrayOfRedeemItemCancel $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get RedemptionLogId value
     * @return int|null
     */
    public function getRedemptionLogId()
    {
        return $this->RedemptionLogId;
    }
    /**
     * Set RedemptionLogId value
     * @param int $redemptionLogId
     * @return \Struct\CancelRedeemRequest
     */
    public function setRedemptionLogId($redemptionLogId = null)
    {
        // validation for constraint: int
        if (!is_null($redemptionLogId) && !(is_int($redemptionLogId) || ctype_digit($redemptionLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($redemptionLogId, true), gettype($redemptionLogId)), __LINE__);
        }
        $this->RedemptionLogId = $redemptionLogId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\CancelRedeemRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
