<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Query ServiceType
 */
$query = new \Service\Query($options);
/**
 * Sample call for QueryAvailableItems operation/method
 */
if ($query->QueryAvailableItems(new \Struct\QueryAvailableItems()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryPoints operation/method
 */
if ($query->QueryPoints(new \Struct\QueryPoints()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryStockPoints operation/method
 */
if ($query->QueryStockPoints(new \Struct\QueryStockPoints()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryDefaultAvailableItems operation/method
 */
if ($query->QueryDefaultAvailableItems(new \Struct\QueryDefaultAvailableItems()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \Service\Get($options);
/**
 * Sample call for GetMyWalletsWithPoints operation/method
 */
if ($get->GetMyWalletsWithPoints(new \Struct\GetMyWalletsWithPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyWalletsWithStockPoints operation/method
 */
if ($get->GetMyWalletsWithStockPoints(new \Struct\GetMyWalletsWithStockPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommandPrice operation/method
 */
if ($get->GetCommandPrice(new \Struct\GetCommandPrice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCommandRestrictions operation/method
 */
if ($get->GetCommandRestrictions(new \Struct\GetCommandRestrictions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLineMembersWalletsCount operation/method
 */
if ($get->GetLineMembersWalletsCount(new \Struct\GetLineMembersWalletsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLineMembersPoints operation/method
 */
if ($get->GetLineMembersPoints(new \Struct\GetLineMembersPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableWalletsForCommand operation/method
 */
if ($get->GetAvailableWalletsForCommand(new \Struct\GetAvailableWalletsForCommand()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransferDetails operation/method
 */
if ($get->GetTransferDetails(new \Struct\GetTransferDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrdersSummary operation/method
 */
if ($get->GetOrdersSummary(new \Struct\GetOrdersSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCataloguesSummary operation/method
 */
if ($get->GetCataloguesSummary(new \Struct\GetCataloguesSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountMembersWithRegistrationInfo operation/method
 */
if ($get->GetAccountMembersWithRegistrationInfo(new \Struct\GetAccountMembersWithRegistrationInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLostPoints operation/method
 */
if ($get->GetLostPoints(new \Struct\GetLostPoints()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNextRedemptionDate operation/method
 */
if ($get->GetNextRedemptionDate(new \Struct\GetNextRedemptionDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryChannels operation/method
 */
if ($get->GetDeliveryChannels(new \Struct\GetDeliveryChannels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableQuantity operation/method
 */
if ($get->GetAvailableQuantity(new \Struct\GetAvailableQuantity()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryChannelTypes operation/method
 */
if ($get->GetDeliveryChannelTypes(new \Struct\GetDeliveryChannelTypes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAreas operation/method
 */
if ($get->GetAreas(new \Struct\GetAreas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetArea operation/method
 */
if ($get->GetArea(new \Struct\GetArea()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \Service\Is($options);
/**
 * Sample call for IsCustomerRegistered operation/method
 */
if ($is->IsCustomerRegistered(new \Struct\IsCustomerRegistered()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Redemption ServiceType
 */
$redemption = new \Service\Redemption($options);
/**
 * Sample call for RedemptionHistory operation/method
 */
if ($redemption->RedemptionHistory(new \Struct\RedemptionHistory()) !== false) {
    print_r($redemption->getResult());
} else {
    print_r($redemption->getLastError());
}
/**
 * Samples for Give ServiceType
 */
$give = new \Service\Give($options);
/**
 * Sample call for GivePoints operation/method
 */
if ($give->GivePoints(new \Struct\GivePoints()) !== false) {
    print_r($give->getResult());
} else {
    print_r($give->getLastError());
}
/**
 * Samples for Take ServiceType
 */
$take = new \Service\Take($options);
/**
 * Sample call for TakePoints operation/method
 */
if ($take->TakePoints(new \Struct\TakePoints()) !== false) {
    print_r($take->getResult());
} else {
    print_r($take->getLastError());
}
/**
 * Samples for Buy ServiceType
 */
$buy = new \Service\Buy($options);
/**
 * Sample call for BuyPoints operation/method
 */
if ($buy->BuyPoints(new \Struct\BuyPoints()) !== false) {
    print_r($buy->getResult());
} else {
    print_r($buy->getLastError());
}
/**
 * Samples for Redeem ServiceType
 */
$redeem = new \Service\Redeem($options);
/**
 * Sample call for RedeemItems operation/method
 */
if ($redeem->RedeemItems(new \Struct\RedeemItems()) !== false) {
    print_r($redeem->getResult());
} else {
    print_r($redeem->getLastError());
}
/**
 * Sample call for RedeemItemsBeta operation/method
 */
if ($redeem->RedeemItemsBeta(new \Struct\RedeemItemsBeta()) !== false) {
    print_r($redeem->getResult());
} else {
    print_r($redeem->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \Service\Cancel($options);
/**
 * Sample call for CancelRedeem operation/method
 */
if ($cancel->CancelRedeem(new \Struct\CancelRedeem()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Deliver ServiceType
 */
$deliver = new \Service\Deliver($options);
/**
 * Sample call for DeliverItems operation/method
 */
if ($deliver->DeliverItems(new \Struct\DeliverItems()) !== false) {
    print_r($deliver->getResult());
} else {
    print_r($deliver->getLastError());
}
/**
 * Samples for Un ServiceType
 */
$un = new \Service\Un($options);
/**
 * Sample call for UnRegister operation/method
 */
if ($un->UnRegister(new \Struct\UnRegister()) !== false) {
    print_r($un->getResult());
} else {
    print_r($un->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \Service\Register($options);
/**
 * Sample call for Register operation/method
 */
if ($register->Register(new \Struct\Register()) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
/**
 * Samples for Redeemable ServiceType
 */
$redeemable = new \Service\Redeemable($options);
/**
 * Sample call for RedeemableItemDetails operation/method
 */
if ($redeemable->RedeemableItemDetails(new \Struct\RedeemableItemDetails()) !== false) {
    print_r($redeemable->getResult());
} else {
    print_r($redeemable->getLastError());
}
/**
 * Samples for Enable ServiceType
 */
$enable = new \Service\Enable($options);
/**
 * Sample call for EnableCustomer operation/method
 */
if ($enable->EnableCustomer(new \Struct\EnableCustomer()) !== false) {
    print_r($enable->getResult());
} else {
    print_r($enable->getLastError());
}
/**
 * Samples for Disable ServiceType
 */
$disable = new \Service\Disable($options);
/**
 * Sample call for DisableCustomer operation/method
 */
if ($disable->DisableCustomer(new \Struct\DisableCustomer()) !== false) {
    print_r($disable->getResult());
} else {
    print_r($disable->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \Service\Add($options);
/**
 * Sample call for AddPoints operation/method
 */
if ($add->AddPoints(new \Struct\AddPoints()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \Service\Remove($options);
/**
 * Sample call for RemovePoints operation/method
 */
if ($remove->RemovePoints(new \Struct\RemovePoints()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Balance ServiceType
 */
$balance = new \Service\Balance($options);
/**
 * Sample call for BalanceHistory operation/method
 */
if ($balance->BalanceHistory(new \Struct\BalanceHistory()) !== false) {
    print_r($balance->getResult());
} else {
    print_r($balance->getLastError());
}
/**
 * Samples for Password ServiceType
 */
$password = new \Service\Password($options);
/**
 * Sample call for PasswordRequest operation/method
 */
if ($password->PasswordRequest(new \Struct\PasswordRequest()) !== false) {
    print_r($password->getResult());
} else {
    print_r($password->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \Service\Send($options);
/**
 * Sample call for SendEmailLink operation/method
 */
if ($send->SendEmailLink(new \Struct\SendEmailLink()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \Service\Change($options);
/**
 * Sample call for ChangePassword operation/method
 */
if ($change->ChangePassword(new \Struct\ChangePassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
