<?php

namespace Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemsQuantityResponse Struct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemsQuantityResponse
 * @subpackage Structs
 * @date 2019-10-21
 */
class ItemsQuantityResponse extends ApiResponse
{
    /**
     * The Quantities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Array\ArrayOfItemQuantity
     */
    public $Quantities;
    /**
     * Constructor method for ItemsQuantityResponse
     * @uses ItemsQuantityResponse::setQuantities()
     * @param \Array\ArrayOfItemQuantity $quantities
     */
    public function __construct(\Array\ArrayOfItemQuantity $quantities = null)
    {
        $this
            ->setQuantities($quantities);
    }
    /**
     * Get Quantities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Array\ArrayOfItemQuantity|null
     */
    public function getQuantities()
    {
        return isset($this->Quantities) ? $this->Quantities : null;
    }
    /**
     * Set Quantities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Array\ArrayOfItemQuantity $quantities
     * @return \Struct\ItemsQuantityResponse
     */
    public function setQuantities(\Array\ArrayOfItemQuantity $quantities = null)
    {
        if (is_null($quantities) || (is_array($quantities) && empty($quantities))) {
            unset($this->Quantities);
        } else {
            $this->Quantities = $quantities;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Struct\ItemsQuantityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
